/*
 * Decompiled with CFR 0.152.
 */
package net.stoerr.ai.aigenpipeline.framework.task;

import java.io.File;
import java.io.IOException;
import java.nio.charset.MalformedInputException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileLookupHelper {
    protected static final Logger LOG = Logger.getLogger(FileLookupHelper.class.getName());
    public static final String HTML_PATTERN = ".*\\.html";
    protected static final Pattern NOMETAPREFIXPATTERN = Pattern.compile("^/?([^/*?{}\\[\\]]+/)+");
    protected static final int FILE_MAXSIZE = 51200;
    protected static final Pattern BINARYFILEPATTERN = Pattern.compile(".*\\.(jpg|gif|png|[jwet]ar|class|zip|gz|tgz|pdf|doc|xls|ppt|docx|xlsx|pptx|odt|ods)");
    protected final File directory;

    protected FileLookupHelper(String path) {
        try {
            this.directory = new File(path).getAbsoluteFile().getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Path " + path + " does not exist", e);
        }
        if (!this.directory.isDirectory()) {
            throw new IllegalStateException("Directory " + this.directory + " does not exist");
        }
    }

    public static FileLookupHelper fromPath(String ... relativePaths) {
        StringBuilder path = new StringBuilder();
        for (String relativePath : relativePaths) {
            path.append(relativePath).append("/");
        }
        return new FileLookupHelper(path.toString());
    }

    public static FileLookupHelper fromEnv(@Nonnull String envVar, @Nullable String relativePath) {
        Object path = System.getenv(envVar);
        if (path == null) {
            throw new IllegalStateException("Environment variable " + envVar + " not set");
        }
        if (relativePath != null) {
            path = (String)path + File.pathSeparator + relativePath;
        }
        return new FileLookupHelper((String)path);
    }

    public File file(String relpath) {
        return new File(this.directory, relpath);
    }

    @Nonnull
    public List<File> files(@Nonnull String relpathDirectory, @Nullable String filePathPattern, boolean recursive) {
        Path dir;
        Matcher fixedPrefixMatcher;
        if (filePathPattern != null && (fixedPrefixMatcher = NOMETAPREFIXPATTERN.matcher(filePathPattern)).find()) {
            String prefix = fixedPrefixMatcher.group();
            relpathDirectory = Path.of(relpathDirectory, new String[0]).resolve(prefix).normalize().toString();
            filePathPattern = filePathPattern.substring(prefix.length());
        }
        if (!(dir = this.directory.toPath().resolve(relpathDirectory).normalize()).toFile().isDirectory()) {
            throw new IllegalStateException("Directory " + dir + " does not exist");
        }
        final PathMatcher pathMatcher = null != filePathPattern && !filePathPattern.isEmpty() ? dir.getFileSystem().getPathMatcher("glob:" + filePathPattern) : null;
        final ArrayList<File> result = new ArrayList<File>();
        if (!recursive) {
            File[] files = dir.toFile().listFiles(file -> pathMatcher == null || pathMatcher.matches(file.toPath()) || pathMatcher.matches(dir.relativize(file.toPath())));
            Arrays.stream(Objects.requireNonNull(files, dir.toString())).filter(File::isFile).forEach(result::add);
        } else {
            try {
                Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path relativePath = dir.relativize(file);
                        if (Files.isRegularFile(file, new LinkOption[0]) && (pathMatcher == null || pathMatcher.matches(relativePath) || pathMatcher.matches(file))) {
                            result.add(file.toFile());
                        }
                        return super.visitFile(file, attrs);
                    }
                });
            }
            catch (IOException e) {
                LOG.severe("for " + dir + ":" + e);
            }
        }
        return result;
    }

    @Nonnull
    public List<File> filesContaining(@Nonnull String relpathDirectory, @Nonnull String filePathPattern, @Nonnull Pattern pattern, boolean recursive) {
        List<File> candidates = this.files(relpathDirectory, filePathPattern, recursive);
        ArrayList<File> result = new ArrayList<File>();
        for (File file : candidates) {
            if (file.length() > 51200L || BINARYFILEPATTERN.matcher(file.getName()).matches()) continue;
            try {
                String content = Files.readString(file.toPath());
                if (!pattern.matcher(content).find()) continue;
                result.add(file);
            }
            catch (MalformedInputException content) {
            }
            catch (IOException e) {
                LOG.severe("for " + file + ":" + e);
            }
        }
        return result;
    }

    @Nonnull
    public File javaFile(@Nonnull String fullName) {
        return new File(this.directory, fullName.replaceAll("[.]", "/") + ".java");
    }

    @Nonnull
    public File javaMdFile(@Nonnull String fullName) {
        return new File(this.directory, fullName.replaceAll("[.]", "/") + ".md");
    }
}

