/*
 * Decompiled with CFR 0.152.
 */
package net.stoerr.ai.aigenpipeline.framework.task;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.stoerr.ai.aigenpipeline.framework.chat.AIChatBuilder;
import net.stoerr.ai.aigenpipeline.framework.task.AIInOut;
import net.stoerr.ai.aigenpipeline.framework.task.AIVersionMarker;
import net.stoerr.ai.aigenpipeline.framework.task.RegenerationCheckStrategy;
import net.stoerr.ai.aigenpipeline.framework.task.WritingStrategy;

public class AIGenerationTask
implements Cloneable {
    protected static final Logger LOG = Logger.getLogger(AIGenerationTask.class.getName());
    public static final String FIXME = "FIXME(GenAIPipeline)";
    protected static final Pattern PATTERN_LICENCE = Pattern.compile("\\A<!--(?s).*?Copyright.*?Adobe.*?Licensed under.*?-->");
    protected static final Pattern PATTERN_INFILEPROMPT = Pattern.compile(".*AIGenPromptStart\\(([^)]*)\\)((?s).*?)AIGenPromptEnd\\(\\1\\).*\n?");
    protected List<AIInOut> inputFiles = new ArrayList<AIInOut>();
    protected List<AIInOut> hints = new ArrayList<AIInOut>();
    protected AIInOut output;
    protected boolean updateRequested = false;
    protected String prompt;
    protected List<AIInOut> promptInputs = new ArrayList<AIInOut>();
    protected Map<String, String> placeholdersAndValues = new LinkedHashMap<String, String>();
    protected String systemMessage;
    protected AIInOut systemMessageInput;
    protected Integer maxTokens;
    protected RegenerationCheckStrategy regenerationCheckStrategy = RegenerationCheckStrategy.VERSIONMARKER;
    protected WritingStrategy writingStrategy = WritingStrategy.WITHVERSION;

    public AIGenerationTask copy() {
        try {
            AIGenerationTask copy = (AIGenerationTask)super.clone();
            copy.inputFiles = new ArrayList<AIInOut>(this.inputFiles);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Bug - impossible.", e);
        }
    }

    public AIGenerationTask maxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    public AIGenerationTask addOptionalInput(@Nullable AIInOut input) {
        if (input != null && input.exists()) {
            this.inputFiles.add(input);
        } else {
            LOG.fine(() -> "Optional file not there: " + input);
        }
        return this;
    }

    public AIGenerationTask addOptionalInputFile(@Nullable File file) {
        return this.addOptionalInput(AIInOut.of(file));
    }

    public AIGenerationTask addInputFiles(List<File> files) {
        for (File file : files) {
            this.addInputFile(file);
        }
        return this;
    }

    public AIGenerationTask addInputs(List<AIInOut> inputs) {
        for (AIInOut input : inputs) {
            this.addInput(input);
        }
        return this;
    }

    public AIGenerationTask addInput(AIInOut input) {
        if (!input.exists()) {
            throw new IllegalArgumentException("File " + input + " does not exist");
        }
        this.inputFiles.add(input);
        return this;
    }

    public AIGenerationTask addInputFile(File file) {
        return this.addInput(AIInOut.of(file));
    }

    public AIGenerationTask addHint(AIInOut hint) {
        this.hints.add(hint);
        return this;
    }

    public AIGenerationTask setOutput(@Nonnull AIInOut output) {
        Objects.requireNonNull(output, "Ouput must not be null");
        this.output = output;
        return this;
    }

    public AIGenerationTask setOutputFile(@Nonnull File file) {
        return this.setOutput(AIInOut.of(file));
    }

    public AIGenerationTask setRegenerationCheckStrategy(RegenerationCheckStrategy strategy) {
        this.regenerationCheckStrategy = strategy;
        return this;
    }

    public AIGenerationTask setWritingStrategy(WritingStrategy strategy) {
        this.writingStrategy = strategy;
        return this;
    }

    public AIGenerationTask setUpdateRequested(boolean updateRequested) {
        this.updateRequested = updateRequested;
        return this;
    }

    public boolean hasToBeRun() {
        List<AIInOut> allInputs = this.getAllInputs();
        List<String> additionalMarkers = this.getAdditionalMarkers();
        List<String> inputVersions = AIVersionMarker.calculateInputMarkers(allInputs, additionalMarkers);
        return this.regenerationCheckStrategy.needsRegeneration(this.output, allInputs, this.writingStrategy, inputVersions);
    }

    protected List<String> getAdditionalMarkers() {
        ArrayList<String> additionalMarkers = new ArrayList<String>();
        if (!this.placeholdersAndValues.isEmpty()) {
            additionalMarkers.add("parms-" + AIVersionMarker.shaHash(this.placeholdersAndValues.toString()));
        }
        return additionalMarkers;
    }

    protected List<AIInOut> getAllInputs() {
        ArrayList<AIInOut> allInputs = new ArrayList<AIInOut>();
        if (this.systemMessageInput != null) {
            allInputs.add(this.systemMessageInput);
        }
        allInputs.addAll(this.promptInputs);
        this.inputFiles.stream().filter(f -> !f.sameFile(this.output)).forEach(allInputs::add);
        return allInputs;
    }

    public AIGenerationTask addPrompt(@Nonnull AIInOut promptInput, String ... placeholdersAndValues) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < placeholdersAndValues.length; i += 2) {
            map.put(placeholdersAndValues[i], placeholdersAndValues[i + 1]);
        }
        return this.addPrompt(promptInput, map);
    }

    public AIGenerationTask addPrompt(@Nonnull File promptInput, String ... placeholdersAndValues) {
        return this.addPrompt(AIInOut.of(promptInput), placeholdersAndValues);
    }

    public AIGenerationTask addPrompt(@Nonnull AIInOut promptFile, Map<String, String> placeholdersAndValues) {
        String fileContent = promptFile.read();
        if (fileContent == null) {
            throw new IllegalArgumentException("Could not read prompt file " + promptFile);
        }
        String newPrompt = AIGenerationTask.unclutter(fileContent);
        Objects.requireNonNull(newPrompt, "Could not read prompt file " + promptFile);
        for (Map.Entry<String, String> entry : placeholdersAndValues.entrySet()) {
            newPrompt = newPrompt.replaceAll(Pattern.quote("${" + entry.getKey() + "}"), entry.getValue());
        }
        this.prompt = this.prompt == null ? newPrompt : this.prompt + "\n\n" + newPrompt;
        this.promptInputs.add(promptFile);
        this.placeholdersAndValues.putAll(placeholdersAndValues);
        return this;
    }

    public AIGenerationTask addPrompt(@Nonnull File promptFile, Map<String, String> placeholdersAndValues) {
        return this.addPrompt(AIInOut.of(promptFile), placeholdersAndValues);
    }

    @Nullable
    protected String getFileContent(@Nonnull File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            return Files.readString(file.toPath(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading file " + file, e);
        }
    }

    public static String unclutter(String content) {
        if (content == null) {
            return null;
        }
        Matcher matcher = PATTERN_LICENCE.matcher(content);
        if (matcher.find()) {
            content = matcher.replaceFirst("");
        }
        if ((matcher = AIVersionMarker.VERSION_MARKER_PATTERN.matcher(content)).find()) {
            content = matcher.replaceFirst("");
        }
        if ((matcher = PATTERN_INFILEPROMPT.matcher(content)).find()) {
            content = matcher.replaceFirst("");
        }
        return content;
    }

    public AIGenerationTask setSystemMessage(@Nonnull AIInOut systemMessageFile) {
        String fileContent = systemMessageFile.read();
        if (fileContent == null) {
            throw new IllegalArgumentException("Could not read system message file " + systemMessageFile);
        }
        String newSystemMessage = AIGenerationTask.unclutter(fileContent);
        Objects.requireNonNull(newSystemMessage, "Could not read system message file " + systemMessageFile);
        this.systemMessage = newSystemMessage;
        this.systemMessageInput = systemMessageFile;
        return this;
    }

    public AIGenerationTask setSystemMessage(@Nonnull File systemMessageFile) {
        return this.setSystemMessage(AIInOut.of(systemMessageFile));
    }

    protected String relativePath(@Nullable File file, @Nonnull File rootDirectory) {
        if (file == null) {
            return null;
        }
        Objects.requireNonNull(rootDirectory, "Root directory must not be null");
        return rootDirectory.toPath().toAbsolutePath().relativize(file.toPath().toAbsolutePath()).toString();
    }

    public AIGenerationTask execute(@Nonnull Supplier<AIChatBuilder> chatBuilderFactory, @Nonnull File rootDirectory) {
        if (!this.hasToBeRun()) {
            LOG.info(() -> "Task does not have to be run for: " + this.output);
            return this;
        }
        AIChatBuilder chat = this.makeChatBuilder(chatBuilderFactory, rootDirectory);
        String result = chat.execute();
        LOG.fine(() -> "Result for task execution for: " + this.output + "\n" + result);
        String outputVersion = AIVersionMarker.shaHash(result);
        List<String> allInputMarkers = AIVersionMarker.calculateInputMarkers(this.getAllInputs(), this.getAdditionalMarkers());
        String versionComment = new AIVersionMarker(outputVersion, allInputMarkers).toString();
        this.writingStrategy.write(this.output, result, versionComment);
        if (result.contains(FIXME)) {
            throw new IllegalStateException("AI returned FIXME for " + this.output + " :\n" + result);
        }
        return this;
    }

    public String toJson(@Nonnull Supplier<AIChatBuilder> chatBuilderFactory, @Nonnull File rootDirectory) {
        return this.makeChatBuilder(chatBuilderFactory, rootDirectory).toJson();
    }

    @Nonnull
    protected AIChatBuilder makeChatBuilder(@Nonnull Supplier<AIChatBuilder> chatBuilderFactory, @Nonnull File rootDirectory) {
        Object outputContent;
        Objects.requireNonNull(this.output, "Output file not writeable: " + this.output);
        if ((this.prompt == null || this.prompt.isBlank()) && (this.systemMessage == null || this.systemMessage.isBlank()) && this.systemMessageInput == null) {
            throw new IllegalArgumentException("No prompt given!");
        }
        AIChatBuilder chat = chatBuilderFactory.get();
        if (this.maxTokens != null) {
            chat.maxTokens(this.maxTokens);
        }
        if (this.systemMessage != null) {
            chat.systemMsg(this.systemMessage);
        } else {
            try (InputStream defaultprompt = AIGenerationTask.class.getResourceAsStream("/defaultsystemprompt.txt");){
                String defaultSysPrompt = new String(Objects.requireNonNull(defaultprompt).readAllBytes(), StandardCharsets.UTF_8);
                chat.systemMsg(defaultSysPrompt);
            }
            catch (IOException e) {
                throw new IllegalStateException("Bug: Error reading default system message", e);
            }
        }
        if (this.updateRequested && (outputContent = this.output.read()) != null) {
            chat.userMsg("Retrieve the current content of the output file. Later you will take this file as basis for the output, check it and possibly modify it, but minimize changes.");
            chat.assistantMsg(AIGenerationTask.unclutter((String)outputContent));
        }
        for (AIInOut file : this.inputFiles) {
            String path = this.relativePath(file.getFile(), rootDirectory);
            if (file.sameFile(this.output)) {
                throw new IllegalArgumentException("The output is also given as input file. Please request an update instead.");
            }
            String usermsg = "Retrieve the content of the input file '" + path + "'";
            chat.userMsg(usermsg);
            String fileContent = file.read();
            if (fileContent == null) {
                throw new IllegalArgumentException("Could not read input file " + file);
            }
            chat.assistantMsg(AIGenerationTask.unclutter(fileContent));
        }
        StringBuilder promptBuilder = new StringBuilder(this.prompt);
        for (AIInOut hint : this.hints) {
            String hintContent = hint.read();
            if (hintContent == null) {
                throw new IllegalArgumentException("Could not read hint file " + hint);
            }
            promptBuilder.append("\n\n").append(AIGenerationTask.unclutter(hintContent));
        }
        chat.userMsg(promptBuilder.toString());
        LOG.fine(() -> "Executing chat for: " + this.output + "\n" + chat.toJson());
        return chat;
    }

    public String explain(@Nonnull Supplier<AIChatBuilder> chatBuilderFactory, @Nonnull File rootDirectory, @Nonnull String question) {
        if (this.hasToBeRun()) {
            System.err.println("Warning: explain results might be invalid since task would need to be run for: " + this.output);
        }
        AIChatBuilder chat = this.makeChatBuilder(chatBuilderFactory, rootDirectory);
        String outputFileContent = this.output.read();
        if (outputFileContent == null) {
            throw new IllegalStateException("Usage error - no previous call? Could not read output file " + this.output);
        }
        String previousOutput = AIGenerationTask.unclutter(outputFileContent);
        Objects.requireNonNull(previousOutput, "Could not read any content from file " + this.output);
        chat.assistantMsg(previousOutput);
        chat.userMsg(question);
        String result = chat.execute();
        LOG.info(() -> "Explanation result for " + this.output + " with question " + question + " is:\n" + result);
        if (result.contains(FIXME)) {
            System.err.println("Warning: AI returned FIXME for explain of " + this.output + " :\n" + result);
        }
        return result;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "AIGenerationTask{inputFiles=" + this.inputFiles + ", outputFile=" + this.output + ", systemMessageFile=" + this.systemMessageInput + ", systemMessage='" + this.systemMessage + "', promptFiles=" + this.promptInputs + ", placeholdersAndValues=" + this.placeholdersAndValues + ", prompt='" + this.prompt + "'}";
    }
}

