/*
 * Decompiled with CFR 0.152.
 */
package net.stoerr.ai.aigenpipeline.framework.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileLookupHelper {
    protected static final Logger LOG = Logger.getLogger(FileLookupHelper.class.getName());
    public static final String HTML_PATTERN = ".*\\.html";
    protected final File directory;

    protected FileLookupHelper(String path) {
        FileLookupHelper.sanityCheck();
        try {
            this.directory = new File(path).getAbsoluteFile().getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Path " + path + " does not exist", e);
        }
        if (!this.directory.isDirectory()) {
            throw new IllegalStateException("Directory " + this.directory + " does not exist");
        }
    }

    protected static void sanityCheck() {
        if (!new File("src/main/java").isDirectory() || !new File("pom.xml").isFile()) {
            throw new IllegalStateException("Something is wrong - we are not started in the maven project, but " + new File(".").getAbsolutePath());
        }
    }

    public static FileLookupHelper fromPath(String ... relativePaths) {
        StringBuilder path = new StringBuilder();
        for (String relativePath : relativePaths) {
            path.append(relativePath).append("/");
        }
        return new FileLookupHelper(path.toString());
    }

    public static FileLookupHelper fromEnv(@Nonnull String envVar, @Nullable String relativePath) {
        Object path = System.getenv(envVar);
        if (path == null) {
            throw new IllegalStateException("Environment variable " + envVar + " not set");
        }
        if (relativePath != null) {
            path = (String)path + "/" + relativePath;
        }
        return new FileLookupHelper((String)path);
    }

    public File file(String relpath) {
        return new File(this.directory, relpath);
    }

    public List<File> files(@Nonnull String relpathDirectory, @Nullable String filePathRegex, boolean recursive) {
        Pattern filePathPattern;
        File dir = new File(this.directory, relpathDirectory);
        if (!dir.isDirectory()) {
            throw new IllegalStateException("Directory " + dir + " does not exist");
        }
        final ArrayList<File> result = new ArrayList<File>();
        Pattern pattern = filePathPattern = filePathRegex != null ? Pattern.compile(filePathRegex) : Pattern.compile(".*");
        if (!recursive) {
            File[] files = dir.listFiles((dir1, name) -> filePathPattern.matcher(dir1 + "/" + name).matches());
            Arrays.stream(Objects.requireNonNull(files, dir.toString())).filter(File::isFile).forEach(result::add);
        } else {
            try {
                Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (filePathPattern.matcher(file.getFileName().toString()).matches()) {
                            result.add(file.toFile());
                        }
                        return super.visitFile(file, attrs);
                    }
                });
            }
            catch (IOException e) {
                LOG.severe("for " + dir + ":" + e);
            }
        }
        return result;
    }

    public List<File> filesContaining(@Nonnull String relpathDirectory, @Nonnull String filePathRegex, @Nonnull String pattern, boolean recursive) {
        List<File> candidates = this.files(relpathDirectory, filePathRegex, recursive);
        ArrayList<File> result = new ArrayList<File>();
        Pattern patternPattern = Pattern.compile(pattern);
        for (File file : candidates) {
            try {
                String content = Files.readString(file.toPath());
                if (!patternPattern.matcher(content).find()) continue;
                result.add(file);
            }
            catch (IOException e) {
                LOG.severe("for " + file + ":" + e);
            }
        }
        return result;
    }

    @Nonnull
    public File javaFile(@Nonnull String fullName) {
        return new File(this.directory, fullName.replaceAll("[.]", "/") + ".java");
    }

    @Nonnull
    public File javaMdFile(@Nonnull String fullName) {
        return new File(this.directory, fullName.replaceAll("[.]", "/") + ".md");
    }
}

