/*
 * Decompiled with CFR 0.152.
 */
package net.stoerr.ai.aigenpipeline.framework.task;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AIVersionMarker {
    public static final Pattern VERSION_MARKER_PATTERN = Pattern.compile("AIGenVersion\\([^)]+\\)");
    protected final String ourVersion;
    protected final List<String> inputVersions;

    public AIVersionMarker(String ourVersion, List<String> inputVersions) {
        this.ourVersion = ourVersion;
        this.inputVersions = null != inputVersions ? new ArrayList<String>(inputVersions) : Collections.emptyList();
    }

    @Nullable
    public static AIVersionMarker find(String content) {
        if (content == null) {
            return null;
        }
        Matcher matcher = VERSION_MARKER_PATTERN.matcher(content);
        if (!matcher.find()) {
            return null;
        }
        String marker = matcher.group();
        String[] parts = (marker = marker.substring(13, marker.length() - 1)).split(", ");
        if (parts.length < 1) {
            return new AIVersionMarker("", Collections.emptyList());
        }
        String ourVersion = parts[0];
        List<String> inputVersions = Arrays.asList(parts).subList(1, parts.length);
        return new AIVersionMarker(ourVersion, inputVersions);
    }

    @Nullable
    public static String replaceMarkerIn(@Nullable String content, @Nonnull String newMarker) {
        if (content == null) {
            return null;
        }
        Matcher matcher = VERSION_MARKER_PATTERN.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        return matcher.replaceFirst(newMarker);
    }

    public static String determineFileVersionMarker(@Nonnull File file) {
        String content;
        try {
            content = Files.readString(file.toPath(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read file " + file, e);
        }
        Objects.requireNonNull(content, "Could not read file " + file);
        AIVersionMarker aiVersionMarker = AIVersionMarker.find(content);
        String version = aiVersionMarker != null ? aiVersionMarker.getOurVersion() : AIVersionMarker.shaHash(content);
        return file.getName() + "-" + version;
    }

    public static String shaHash(String content) {
        String condensedWhitespace = content.replaceAll("\\s+", " ");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(condensedWhitespace.getBytes(StandardCharsets.UTF_8));
            long hashNumber = (((long)hash[3] * 256L + (long)hash[2]) * 256L + (long)hash[1]) * 256L + (long)hash[0];
            String hexString = "00000000" + Long.toHexString(Math.abs(hashNumber));
            return hexString.substring(hexString.length() - 8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA256 not available", e);
        }
    }

    public static List<String> calculateInputMarkers(List<File> inputs, List<String> additionalMarkers) {
        List<String> inputVersions = inputs.stream().map(AIVersionMarker::determineFileVersionMarker).collect(Collectors.toList());
        inputVersions.addAll(additionalMarkers);
        return inputVersions;
    }

    public int hashCode() {
        return Objects.hash(this.ourVersion, this.inputVersions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AIVersionMarker other = (AIVersionMarker)obj;
        return Objects.equals(this.ourVersion, other.ourVersion) && Objects.equals(this.inputVersions, other.inputVersions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AIGenVersion(");
        sb.append(this.ourVersion);
        this.inputVersions.forEach(version -> sb.append(", ").append((String)version));
        sb.append(")");
        return sb.toString();
    }

    public String getOurVersion() {
        return this.ourVersion;
    }

    public List<String> getInputVersions() {
        return Collections.unmodifiableList(this.inputVersions);
    }
}

