/*
 * Decompiled with CFR 0.152.
 */
package net.stoerr.ai.aigenpipeline.framework.task;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.stoerr.ai.aigenpipeline.framework.chat.AIChatBuilder;
import net.stoerr.ai.aigenpipeline.framework.task.AIVersionMarker;
import net.stoerr.ai.aigenpipeline.framework.task.RegenerationCheckStrategy;
import net.stoerr.ai.aigenpipeline.framework.task.WritingStrategy;

public class AIGenerationTask
implements Cloneable {
    protected static final Logger LOG = Logger.getLogger(AIGenerationTask.class.getName());
    public static final String FIXME = "FIXME";
    protected static final Pattern PATTERN_LICENCE = Pattern.compile("\\A<!--(?s).*?Copyright.*?Adobe.*?Licensed under.*?-->");
    protected List<File> inputFiles = new ArrayList<File>();
    protected File outputFile;
    protected String prompt;
    protected List<File> promptFiles = new ArrayList<File>();
    protected Map<String, String> placeholdersAndValues = new LinkedHashMap<String, String>();
    protected String systemMessage;
    protected File systemMessageFile;
    protected Integer maxTokens;
    protected RegenerationCheckStrategy regenerationCheckStrategy = RegenerationCheckStrategy.VERSIONMARKER;
    protected WritingStrategy writingStrategy = WritingStrategy.WITHVERSION;

    public AIGenerationTask copy() {
        try {
            AIGenerationTask copy = (AIGenerationTask)super.clone();
            copy.inputFiles = new ArrayList<File>(this.inputFiles);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Bug - impossible.", e);
        }
    }

    public AIGenerationTask maxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    public AIGenerationTask addOptionalInputFile(@Nullable File file) {
        if (file != null && file.exists()) {
            this.inputFiles.add(file);
        } else {
            LOG.fine(() -> "Optional file not there: " + file);
        }
        return this;
    }

    public AIGenerationTask addInputFiles(List<File> files) {
        for (File file : files) {
            this.addInputFile(file);
        }
        return this;
    }

    public AIGenerationTask addInputFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File " + file + " does not exist");
        }
        this.inputFiles.add(file);
        return this;
    }

    public AIGenerationTask setOutputFile(@Nonnull File file) {
        Objects.requireNonNull(file, "File must not be null");
        this.outputFile = file;
        return this;
    }

    public AIGenerationTask setRegenerationCheckStrategy(RegenerationCheckStrategy strategy) {
        this.regenerationCheckStrategy = strategy;
        return this;
    }

    public AIGenerationTask setWritingStrategy(WritingStrategy strategy) {
        this.writingStrategy = strategy;
        return this;
    }

    public boolean hasToBeRun() throws IOException {
        List<File> allInputs = this.getAllInputFiles();
        List<String> additionalMarkers = this.getAdditionalMarkers();
        List<String> inputVersions = AIVersionMarker.calculateInputMarkers(allInputs, additionalMarkers);
        return this.regenerationCheckStrategy.needsRegeneration(this.outputFile, allInputs, this.writingStrategy, inputVersions);
    }

    protected List<String> getAdditionalMarkers() {
        ArrayList<String> additionalMarkers = new ArrayList<String>();
        if (!this.placeholdersAndValues.isEmpty()) {
            additionalMarkers.add("parms-" + AIVersionMarker.shaHash(this.placeholdersAndValues.toString()));
        }
        return additionalMarkers;
    }

    protected List<File> getAllInputFiles() {
        ArrayList<File> allInputs = new ArrayList<File>();
        if (this.systemMessageFile != null) {
            allInputs.add(this.systemMessageFile);
        }
        this.promptFiles.stream().filter(f -> !f.getAbsolutePath().equals(this.outputFile.getAbsolutePath())).forEach(allInputs::add);
        this.inputFiles.stream().filter(f -> !f.getAbsolutePath().equals(this.outputFile.getAbsolutePath())).forEach(allInputs::add);
        return allInputs;
    }

    public AIGenerationTask addPrompt(@Nonnull File promptFile, String ... placeholdersAndValues) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < placeholdersAndValues.length; i += 2) {
            map.put(placeholdersAndValues[i], placeholdersAndValues[i + 1]);
        }
        return this.addPrompt(promptFile, map);
    }

    public AIGenerationTask addPrompt(@Nonnull File promptFile, Map<String, String> placeholdersAndValues) {
        String fileContent = this.getFileContent(promptFile);
        if (fileContent == null) {
            throw new IllegalArgumentException("Could not read prompt file " + promptFile);
        }
        String newPrompt = AIGenerationTask.unclutter(fileContent);
        Objects.requireNonNull(newPrompt, "Could not read prompt file " + promptFile);
        for (Map.Entry<String, String> entry : placeholdersAndValues.entrySet()) {
            newPrompt = newPrompt.replace(entry.getKey(), entry.getValue());
        }
        this.prompt = this.prompt == null ? newPrompt : this.prompt + "\n\n" + newPrompt;
        this.promptFiles.add(promptFile);
        this.placeholdersAndValues.putAll(placeholdersAndValues);
        return this;
    }

    @Nullable
    protected String getFileContent(@Nonnull File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            return Files.readString(file.toPath(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading file " + file, e);
        }
    }

    protected static String unclutter(String content) {
        if (content == null) {
            return null;
        }
        Matcher matcher = PATTERN_LICENCE.matcher(content);
        if (matcher.find()) {
            content = matcher.replaceFirst("");
        }
        if ((matcher = AIVersionMarker.VERSION_MARKER_PATTERN.matcher(content)).find()) {
            content = matcher.replaceFirst("");
        }
        return content;
    }

    public AIGenerationTask setSystemMessage(@Nonnull File systemMessageFile) {
        String fileContent = this.getFileContent(systemMessageFile);
        if (fileContent == null) {
            throw new IllegalArgumentException("Could not read system message file " + systemMessageFile);
        }
        String newSystemMessage = AIGenerationTask.unclutter(fileContent);
        Objects.requireNonNull(newSystemMessage, "Could not read system message file " + systemMessageFile);
        this.systemMessage = newSystemMessage;
        this.systemMessageFile = systemMessageFile;
        return this;
    }

    protected String relativePath(@Nullable File file, @Nonnull File rootDirectory) {
        if (file == null) {
            return null;
        }
        Objects.requireNonNull(rootDirectory, "Root directory must not be null");
        try {
            String rootPath = rootDirectory.getAbsoluteFile().getCanonicalFile().getAbsolutePath();
            String filePath = file.getAbsoluteFile().getCanonicalFile().getAbsolutePath();
            if (!filePath.startsWith(rootPath)) {
                throw new IllegalArgumentException("File " + file + " is not in root directory " + rootDirectory);
            }
            return filePath.substring(rootPath.length() + 1);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error getting canonical path for " + rootDirectory + " or " + file, e);
        }
    }

    public AIGenerationTask execute(@Nonnull Supplier<AIChatBuilder> chatBuilderFactory, @Nonnull File rootDirectory) throws IOException {
        String outputRelPath = this.relativePath(this.outputFile, rootDirectory);
        if (!this.hasToBeRun()) {
            LOG.info(() -> "Task does not have to be run for: " + outputRelPath);
            return this;
        }
        AIChatBuilder chat = this.makeChatBuilder(chatBuilderFactory, rootDirectory, outputRelPath);
        String result = chat.execute();
        LOG.fine(() -> "Result for task execution for: " + outputRelPath + "\n" + result);
        String outputVersion = AIVersionMarker.shaHash(result);
        List<String> allInputMarkers = AIVersionMarker.calculateInputMarkers(this.getAllInputFiles(), this.getAdditionalMarkers());
        String versionComment = new AIVersionMarker(outputVersion, allInputMarkers).toString();
        this.writingStrategy.write(this.outputFile, result, versionComment);
        if (result.contains(FIXME)) {
            throw new IllegalStateException("AI returned FIXME for " + outputRelPath + " :\n" + result);
        }
        return this;
    }

    public String toJson(@Nonnull Supplier<AIChatBuilder> chatBuilderFactory, @Nonnull File rootDirectory) {
        String outputRelPath = this.relativePath(this.outputFile, rootDirectory);
        return this.makeChatBuilder(chatBuilderFactory, rootDirectory, outputRelPath).toJson();
    }

    @Nonnull
    protected AIChatBuilder makeChatBuilder(@Nonnull Supplier<AIChatBuilder> chatBuilderFactory, @Nonnull File rootDirectory, String outputRelPath) {
        Objects.requireNonNull(this.outputFile, "Output file not writeable: " + this.outputFile);
        if (null != this.outputFile.getParentFile() && !this.outputFile.getParentFile().isDirectory()) {
            this.outputFile.getParentFile().mkdirs();
        }
        if (this.outputFile.exists() && !this.outputFile.canWrite()) {
            throw new IllegalArgumentException("No writeable output file given! " + this.outputFile);
        }
        if ((this.prompt == null || this.prompt.isBlank()) && (this.systemMessage == null || this.systemMessage.isBlank()) && this.systemMessageFile == null) {
            throw new IllegalArgumentException("No prompt given!");
        }
        AIChatBuilder chat = chatBuilderFactory.get();
        if (this.maxTokens != null) {
            chat.maxTokens(this.maxTokens);
        }
        if (this.systemMessage != null) {
            chat.systemMsg(this.systemMessage);
        } else {
            try (InputStream defaultprompt = AIGenerationTask.class.getResourceAsStream("/defaultsystemprompt.txt");){
                String defaultSysPrompt = new String(Objects.requireNonNull(defaultprompt).readAllBytes(), StandardCharsets.UTF_8);
                chat.systemMsg(defaultSysPrompt);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error reading default system message", e);
            }
        }
        this.inputFiles.forEach(file -> {
            String path = this.relativePath((File)file, rootDirectory);
            String usermsg = !file.getAbsolutePath().equals(this.outputFile.getAbsolutePath()) ? "Retrieve the content of the input file " + path : "Retrieve the current content of the output file " + path + " Later you will take this file as basis for the output, check it and possibly modify it, but minimize changes.";
            chat.userMsg(usermsg);
            String fileContent = this.getFileContent((File)file);
            if (fileContent == null) {
                throw new IllegalArgumentException("Could not read input file " + file);
            }
            chat.assistantMsg(AIGenerationTask.unclutter(fileContent));
        });
        chat.userMsg(this.prompt);
        LOG.fine(() -> "Executing chat for: " + outputRelPath + "\n" + chat.toJson());
        return chat;
    }

    public String explain(@Nonnull Supplier<AIChatBuilder> chatBuilderFactory, @Nonnull File rootDirectory, @Nonnull String question) throws IOException {
        String outputRelPath = this.relativePath(this.outputFile, rootDirectory);
        if (this.hasToBeRun()) {
            throw new IllegalStateException("Task has to be already run for: " + outputRelPath);
        }
        AIChatBuilder chat = this.makeChatBuilder(chatBuilderFactory, rootDirectory, outputRelPath);
        String outputFileContent = this.getFileContent(this.outputFile);
        if (outputFileContent == null) {
            throw new IllegalStateException("Usage error - no previous call? Could not read output file " + this.outputFile);
        }
        String previousOutput = AIGenerationTask.unclutter(outputFileContent);
        Objects.requireNonNull(previousOutput, "Could not read any content from file " + this.outputFile);
        chat.assistantMsg(previousOutput);
        chat.userMsg(question);
        String result = chat.execute();
        LOG.info(() -> "Explanation result for " + outputRelPath + " with question " + question + " is:\n" + result);
        if (result.contains(FIXME)) {
            throw new IllegalStateException("AI returned FIXME for " + outputRelPath + " :\n" + result);
        }
        return result;
    }

    public String toString() {
        return "AIGenerationTask{inputFiles=" + this.inputFiles + ", outputFile=" + this.outputFile + ", systemMessageFile=" + this.systemMessageFile + ", systemMessage='" + this.systemMessage + "', promptFiles=" + this.promptFiles + ", placeholdersAndValues=" + this.placeholdersAndValues + ", prompt='" + this.prompt + "'}";
    }
}

