/*
 * Decompiled with CFR 0.152.
 */
package net.stoerr.ai.aigenpipeline.framework.task;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.stoerr.ai.aigenpipeline.framework.task.AIVersionMarker;

public interface WritingStrategy {
    public static final WritingStrategy WITHOUTVERSION = new WritingStrategy(){

        @Override
        public void write(@Nonnull File output, @Nonnull String content, @Nonnull String versionComment) throws IOException {
            Files.write(output.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }

        @Override
        public AIVersionMarker getRecordedVersionMarker(@Nonnull File output) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Cannot read version marker from file without version comment.");
        }
    };
    public static final WritingStrategy WITHVERSION = new WritingStrategy(){

        @Override
        public void write(@Nonnull File output, @Nonnull String content, @Nonnull String versionComment) throws IOException {
            Files.write(output.toPath(), this.embedComment(output, content, versionComment).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }

        @Override
        public AIVersionMarker getRecordedVersionMarker(@Nonnull File output) throws IOException {
            if (!output.exists()) {
                return null;
            }
            String content = Files.readString(output.toPath(), StandardCharsets.UTF_8);
            if (content == null) {
                return null;
            }
            AIVersionMarker aiVersionMarker = AIVersionMarker.find(content);
            if (aiVersionMarker == null) {
                throw new IllegalStateException("Could not find version marker in " + output);
            }
            return aiVersionMarker;
        }

        protected String embedComment(@Nonnull File outputFile, String content, String comment) {
            Object result;
            String extension;
            switch (extension = outputFile.getName().substring(outputFile.getName().lastIndexOf(46) + 1)) {
                case "java": 
                case "txt": {
                    result = "// " + comment + "\n\n" + content;
                    break;
                }
                case "html": 
                case "htm": 
                case "xml": 
                case "jsp": {
                    result = content + "\n\n<!-- " + comment + " -->\n";
                    break;
                }
                case "css": 
                case "js": 
                case "json": {
                    result = "/* " + comment + " */\n\n" + content;
                    break;
                }
                case "md": {
                    if (content.startsWith("---\n")) {
                        result = content.replaceFirst("---\n", "---\nversion: " + comment + "\n");
                        break;
                    }
                    result = "---\nversion: " + comment + "\n---\n\n" + content;
                    break;
                }
                case "sh": 
                case "yaml": {
                    result = "# " + comment + "\n" + content;
                    break;
                }
                default: {
                    result = "/* " + comment + " */\n\n" + content;
                }
            }
            if (!((String)result).endsWith("\n")) {
                result = (String)result + "\n";
            }
            return result;
        }
    };

    public void write(@Nonnull File var1, @Nonnull String var2, @Nonnull String var3) throws IOException;

    public AIVersionMarker getRecordedVersionMarker(@Nonnull File var1) throws IOException;

    public static class WritePartStrategy
    implements WritingStrategy {
        private final String marker;

        public WritePartStrategy(String marker) {
            this.marker = marker;
        }

        @Override
        public AIVersionMarker getRecordedVersionMarker(@Nonnull File output) throws IOException {
            try (Stream<String> lines = Files.lines(output.toPath());){
                String markerLine = lines.filter(line -> line.contains(this.marker)).findFirst().orElseThrow(() -> new IllegalStateException("Could not find marker " + this.marker + " in " + output));
                AIVersionMarker versionMarker = AIVersionMarker.find(markerLine);
                if (versionMarker == null) {
                    throw new IllegalStateException("Could not find version marker in " + output + " line " + markerLine);
                }
                AIVersionMarker aIVersionMarker = versionMarker;
                return aIVersionMarker;
            }
        }

        @Override
        public void write(@Nonnull File output, @Nonnull String content, @Nonnull String versionComment) throws IOException {
            if (!output.exists()) {
                throw new IllegalArgumentException("File " + output + " does not exist. Required for WritePartStrategy.");
            }
            List<String> lines = Files.readAllLines(output.toPath(), StandardCharsets.UTF_8);
            if (lines.stream().filter(line -> line.contains(this.marker)).count() != 2L) {
                throw new IllegalArgumentException("Marker " + this.marker + " is not exactly twice in " + output);
            }
            int firstMarker = lines.indexOf(lines.stream().filter(line -> line.contains(this.marker)).findFirst().get());
            List<String> rest = lines.subList(firstMarker + 1, lines.size());
            int secondMarker = rest.indexOf(rest.stream().filter(line -> line.contains(this.marker)).findFirst().get()) + firstMarker + 1;
            if (content.contains(this.marker)) {
                throw new IllegalArgumentException("Content contains marker " + this.marker + ". That would lead to trouble next time.");
            }
            String firstMarkerLineNew = AIVersionMarker.replaceMarkerIn(lines.get(firstMarker), versionComment);
            if (AIVersionMarker.find(firstMarkerLineNew) == null) {
                throw new IllegalArgumentException("Bug: cannot find new version marker in new first marker line" + firstMarkerLineNew);
            }
            ArrayList<String> newLines = new ArrayList<String>(lines.subList(0, firstMarker));
            newLines.add(firstMarkerLineNew);
            newLines.add(content);
            newLines.addAll(lines.subList(secondMarker, lines.size()));
            Files.write(output.toPath(), newLines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }
}

