/*
 * Decompiled with CFR 0.152.
 */
package net.stoerr.ai.aigenpipeline.framework.task;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.stoerr.ai.aigenpipeline.framework.task.AIVersionMarker;
import net.stoerr.ai.aigenpipeline.framework.task.WritingStrategy;

public interface RegenerationCheckStrategy {
    public static final RegenerationCheckStrategy ALWAYS = (output, inputs, writingStrategy, inputVersions) -> true;
    public static final RegenerationCheckStrategy IF_NOT_EXISTS = (output, inputs, writingStrategy, additionalMarkers) -> !output.exists();
    public static final RegenerationCheckStrategy IF_OLDER = (output, inputs, writingStrategy, inputVersions) -> {
        if (!output.exists()) {
            return true;
        }
        long outputTime = output.lastModified();
        for (File input : inputs) {
            if (input.getName().equals("-") || input.lastModified() <= outputTime) continue;
            return true;
        }
        return false;
    };
    public static final RegenerationCheckStrategy VERSIONMARKER = new VersionMarkerRegenerationCheckStrategy();

    public boolean needsRegeneration(@Nonnull File var1, @Nonnull List<File> var2, @Nonnull WritingStrategy var3, @Nonnull List<String> var4) throws IOException;

    public static class VersionMarkerRegenerationCheckStrategy
    implements RegenerationCheckStrategy {
        @Override
        public boolean needsRegeneration(@Nonnull File output, @Nonnull List<File> inputs, @Nonnull WritingStrategy writingStrategy, @Nonnull List<String> inputVersions) throws IOException {
            if (!output.exists()) {
                return true;
            }
            AIVersionMarker outputVersionMarker = writingStrategy.getRecordedVersionMarker(output);
            if (outputVersionMarker == null) {
                return true;
            }
            List<String> oldInputVersions = outputVersionMarker.getInputVersions();
            return !new HashSet<String>(inputVersions).equals(new HashSet<String>(oldInputVersions));
        }
    }
}

