/*
 * Decompiled with CFR 0.152.
 */
package net.stoerr.ai.aigenpipeline.framework.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class AIVersionMarker {
    public static final Pattern VERSION_MARKER_PATTERN = Pattern.compile("AIGenVersion\\([^)]+\\)");
    protected final String ourVersion;
    protected final List<String> inputVersions;

    public AIVersionMarker(String ourVersion, List<String> inputVersions) {
        this.ourVersion = ourVersion;
        this.inputVersions = null != inputVersions ? new ArrayList<String>(inputVersions) : Collections.emptyList();
    }

    @Nullable
    public static AIVersionMarker find(String content) {
        if (content == null) {
            return null;
        }
        Matcher matcher = VERSION_MARKER_PATTERN.matcher(content);
        if (!matcher.find()) {
            return null;
        }
        String marker = matcher.group();
        String[] parts = (marker = marker.substring(13, marker.length() - 1)).split(", ");
        if (parts.length < 1) {
            return new AIVersionMarker("", Collections.emptyList());
        }
        String ourVersion = parts[0];
        ArrayList<String> inputVersions = new ArrayList<String>();
        for (int i = 1; i < parts.length; ++i) {
            inputVersions.add(parts[i]);
        }
        return new AIVersionMarker(ourVersion, inputVersions);
    }

    public int hashCode() {
        return Objects.hash(this.ourVersion, this.inputVersions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AIVersionMarker other = (AIVersionMarker)obj;
        return Objects.equals(this.ourVersion, other.ourVersion) && Objects.equals(this.inputVersions, other.inputVersions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AIGenVersion(");
        sb.append(this.ourVersion);
        this.inputVersions.forEach(version -> sb.append(", ").append((String)version));
        sb.append(")");
        return sb.toString();
    }

    public String getOurVersion() {
        return this.ourVersion;
    }

    public List<String> getInputVersions() {
        return Collections.unmodifiableList(this.inputVersions);
    }
}

