/*
 * Decompiled with CFR 0.152.
 */
package net.stoerr.ai.aigenpipeline.framework.task;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.stoerr.ai.aigenpipeline.framework.chat.AIChatBuilder;
import net.stoerr.ai.aigenpipeline.framework.task.AIVersionMarker;

public class AIGenerationTask
implements Cloneable {
    protected static final Logger LOG = Logger.getLogger(AIGenerationTask.class.getName());
    public static final String FIXME = "FIXME";
    protected static final Pattern PATTERN_LICENCE = Pattern.compile("\\A<!--(?s).*?Copyright.*?Adobe.*?Licensed under.*?-->");
    protected List<File> inputFiles = new ArrayList<File>();
    protected File outputFile;
    protected String prompt;
    protected List<File> promptFiles = new ArrayList<File>();
    protected Map<String, String> placeholdersAndValues = new LinkedHashMap<String, String>();
    protected String systemMessage;
    protected File systemMessageFile;
    protected boolean force;
    protected Integer maxTokens;

    public AIGenerationTask copy() {
        try {
            AIGenerationTask copy = (AIGenerationTask)super.clone();
            copy.inputFiles = new ArrayList<File>(this.inputFiles);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Bug - impossible.", e);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public AIGenerationTask maxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    public AIGenerationTask addOptionalInputFile(@Nullable File file) {
        if (file != null && file.exists()) {
            this.inputFiles.add(file);
        } else {
            LOG.fine(() -> "Optional file not there: " + file);
        }
        return this;
    }

    public AIGenerationTask addInputFiles(List<File> files) {
        for (File file : files) {
            this.addInputFile(file);
        }
        return this;
    }

    public AIGenerationTask addInputFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File " + file + " does not exist");
        }
        this.inputFiles.add(file);
        return this;
    }

    public AIGenerationTask setOutputFile(@Nonnull File file) {
        Objects.requireNonNull(file, "File must not be null");
        this.outputFile = file;
        return this;
    }

    protected String embedComment(String content, String comment) {
        Object result;
        String extension;
        switch (extension = this.outputFile.getName().substring(this.outputFile.getName().lastIndexOf(46) + 1)) {
            case "java": 
            case "txt": {
                result = "// " + comment + "\n\n" + content;
                break;
            }
            case "html": 
            case "htm": 
            case "xml": 
            case "jsp": {
                result = content + "\n\n<!-- " + comment + " -->\n";
                break;
            }
            case "css": 
            case "js": 
            case "json": {
                result = "/* " + comment + " */\n\n" + content;
                break;
            }
            case "md": {
                if (content.startsWith("---\n")) {
                    result = content.replaceFirst("---\n", "---\nversion: " + comment + "\n");
                    break;
                }
                result = "---\nversion: " + comment + "\n---\n\n" + content;
                break;
            }
            case "sh": 
            case "yaml": {
                result = "# " + comment + "\n" + content;
                break;
            }
            default: {
                result = "/* " + comment + " */\n\n" + content;
            }
        }
        if (!((String)result).endsWith("\n")) {
            result = (String)result + "\n";
        }
        return result;
    }

    public boolean hasToBeRun() {
        List<String> oldInputVersions;
        if (!this.outputFile.exists()) {
            return true;
        }
        AIVersionMarker outputVersionMarker = this.getRecordedOutputVersionMarker();
        if (outputVersionMarker == null) {
            return true;
        }
        List<String> inputVersions = this.calculateAllInputsMarkers();
        return !new HashSet<String>(inputVersions).equals(new HashSet<String>(oldInputVersions = outputVersionMarker.getInputVersions()));
    }

    @Nonnull
    protected List<String> calculateAllInputsMarkers() {
        ArrayList<String> allInputsMarkers = new ArrayList<String>();
        if (this.systemMessageFile != null) {
            allInputsMarkers.add(this.determineFileVersionMarker(this.systemMessageFile));
        }
        this.promptFiles.stream().filter(f -> !f.getAbsolutePath().equals(this.outputFile.getAbsolutePath())).forEach(file -> allInputsMarkers.add(this.determineFileVersionMarker((File)file)));
        this.inputFiles.stream().filter(f -> !f.getAbsolutePath().equals(this.outputFile.getAbsolutePath())).forEach(file -> allInputsMarkers.add(this.determineFileVersionMarker((File)file)));
        if (!this.placeholdersAndValues.isEmpty()) {
            allInputsMarkers.add("parms-" + this.shaHash(this.placeholdersAndValues.toString()));
        }
        return allInputsMarkers;
    }

    protected String determineFileVersionMarker(@Nonnull File file) {
        String content = this.getFileContent(file);
        Objects.requireNonNull(content, "Could not read file " + file);
        AIVersionMarker aiVersionMarker = AIVersionMarker.find(content);
        String version = aiVersionMarker != null ? aiVersionMarker.getOurVersion() : this.shaHash(content);
        return file.getName() + "-" + version;
    }

    protected String shaHash(String content) {
        String condensedWhitespace = content.replaceAll("\\s+", " ");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(condensedWhitespace.getBytes(StandardCharsets.UTF_8));
            long hashNumber = (((long)hash[3] * 256L + (long)hash[2]) * 256L + (long)hash[1]) * 256L + (long)hash[0];
            String hexString = "00000000" + Long.toHexString(Math.abs(hashNumber));
            return hexString.substring(hexString.length() - 8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA256 not available", e);
        }
    }

    protected AIVersionMarker getRecordedOutputVersionMarker() {
        if (!this.outputFile.exists()) {
            return null;
        }
        String content = this.getFileContent(this.outputFile);
        if (content == null) {
            return null;
        }
        AIVersionMarker aiVersionMarker = AIVersionMarker.find(content);
        if (aiVersionMarker == null) {
            throw new IllegalStateException("Could not find version marker in " + this.outputFile);
        }
        return aiVersionMarker;
    }

    public AIGenerationTask addPrompt(@Nonnull File promptFile, String ... placeholdersAndValues) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < placeholdersAndValues.length; i += 2) {
            map.put(placeholdersAndValues[i], placeholdersAndValues[i + 1]);
        }
        return this.addPrompt(promptFile, map);
    }

    public AIGenerationTask addPrompt(@Nonnull File promptFile, Map<String, String> placeholdersAndValues) {
        String fileContent = this.getFileContent(promptFile);
        if (fileContent == null) {
            throw new IllegalArgumentException("Could not read prompt file " + promptFile);
        }
        String newPrompt = AIGenerationTask.unclutter(fileContent);
        Objects.requireNonNull(newPrompt, "Could not read prompt file " + promptFile);
        for (Map.Entry<String, String> entry : placeholdersAndValues.entrySet()) {
            newPrompt = newPrompt.replace(entry.getKey(), entry.getValue());
        }
        this.prompt = this.prompt == null ? newPrompt : this.prompt + "\n\n" + newPrompt;
        this.promptFiles.add(promptFile);
        this.placeholdersAndValues.putAll(placeholdersAndValues);
        return this;
    }

    protected String getFileContent(@Nonnull File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            return Files.readString(file.toPath(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading file " + file, e);
        }
    }

    protected static String unclutter(String content) {
        Matcher matcher = PATTERN_LICENCE.matcher(content);
        if (matcher.find()) {
            content = matcher.replaceFirst("");
        }
        if ((matcher = AIVersionMarker.VERSION_MARKER_PATTERN.matcher(content)).find()) {
            content = matcher.replaceFirst("");
        }
        return content;
    }

    public AIGenerationTask setSystemMessage(@Nonnull File systemMessageFile) {
        String newSystemMessage = AIGenerationTask.unclutter(this.getFileContent(systemMessageFile));
        Objects.requireNonNull(newSystemMessage, "Could not read system message file " + systemMessageFile);
        this.systemMessage = newSystemMessage;
        this.systemMessageFile = systemMessageFile;
        return this;
    }

    protected String relativePath(@Nullable File file, @Nonnull File rootDirectory) {
        if (file == null) {
            return null;
        }
        Objects.requireNonNull(rootDirectory, "Root directory must not be null");
        String rootPath = null;
        try {
            rootPath = rootDirectory.getAbsoluteFile().getCanonicalFile().getAbsolutePath();
            String filePath = file.getAbsoluteFile().getCanonicalFile().getAbsolutePath();
            if (!filePath.startsWith(rootPath)) {
                throw new IllegalArgumentException("File " + file + " is not in root directory " + rootDirectory);
            }
            return filePath.substring(rootPath.length() + 1);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error getting canonical path for " + rootDirectory + " or " + file, e);
        }
    }

    public AIGenerationTask execute(@Nonnull Supplier<AIChatBuilder> chatBuilderFactory, @Nonnull File rootDirectory) {
        String outputRelPath = this.relativePath(this.outputFile, rootDirectory);
        if (!this.force && !this.hasToBeRun()) {
            LOG.info(() -> "Task does not have to be run for: " + outputRelPath);
            return this;
        }
        AIChatBuilder chat = this.makeChatBuilder(chatBuilderFactory, rootDirectory, outputRelPath);
        String result = chat.execute();
        LOG.fine(() -> "Result for task execution for: " + outputRelPath + "\n" + result);
        String outputVersion = this.shaHash(result);
        String versionComment = new AIVersionMarker(outputVersion, this.calculateAllInputsMarkers()).toString();
        String withVersionComment = this.embedComment(result, versionComment);
        try {
            Files.write(this.outputFile.toPath(), withVersionComment.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error writing file " + this.outputFile, e);
        }
        LOG.info("Wrote file file://" + this.outputFile.getAbsolutePath());
        if (result.contains(FIXME)) {
            throw new IllegalStateException("AI returned FIXME for " + outputRelPath + " :\n" + result);
        }
        return this;
    }

    public String toJson(@Nonnull Supplier<AIChatBuilder> chatBuilderFactory, @Nonnull File rootDirectory) {
        String outputRelPath = this.relativePath(this.outputFile, rootDirectory);
        return this.makeChatBuilder(chatBuilderFactory, rootDirectory, outputRelPath).toJson();
    }

    @Nonnull
    protected AIChatBuilder makeChatBuilder(@Nonnull Supplier<AIChatBuilder> chatBuilderFactory, @Nonnull File rootDirectory, String outputRelPath) {
        Objects.requireNonNull(this.outputFile, "No writeable output file given! " + this.outputFile);
        if (null != this.outputFile.getParentFile() && !this.outputFile.getParentFile().isDirectory()) {
            this.outputFile.getParentFile().mkdirs();
        }
        if (this.outputFile.exists() && !this.outputFile.canWrite()) {
            throw new IllegalArgumentException("No writeable output file given! " + this.outputFile);
        }
        if (this.prompt == null || this.prompt.isBlank()) {
            throw new IllegalArgumentException("No prompt given!");
        }
        AIChatBuilder chat = chatBuilderFactory.get();
        if (this.maxTokens != null) {
            chat.maxTokens(this.maxTokens);
        }
        if (this.systemMessage != null && !this.systemMessage.isBlank()) {
            chat.systemMsg(this.systemMessage);
        } else {
            try (InputStream defaultprompt = AIGenerationTask.class.getResourceAsStream("/defaultsystemprompt.txt");){
                String defaultSysPrompt = new String(defaultprompt.readAllBytes(), StandardCharsets.UTF_8);
                chat.systemMsg(defaultSysPrompt);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error reading default system message", e);
            }
        }
        this.inputFiles.forEach(file -> {
            chat.userMsg("Retrieve the content of the input file " + this.relativePath((File)file, rootDirectory));
            chat.assistantMsg(AIGenerationTask.unclutter(this.getFileContent((File)file)));
        });
        chat.userMsg(this.prompt);
        LOG.fine(() -> "Executing chat for: " + outputRelPath + "\n" + chat.toJson());
        return chat;
    }

    public String explain(@Nonnull Supplier<AIChatBuilder> chatBuilderFactory, @Nonnull File rootDirectory, @Nonnull String question) {
        String outputRelPath = this.relativePath(this.outputFile, rootDirectory);
        if (this.hasToBeRun()) {
            throw new IllegalStateException("Task has to be already run for: " + outputRelPath);
        }
        AIChatBuilder chat = this.makeChatBuilder(chatBuilderFactory, rootDirectory, outputRelPath);
        String previousOutput = AIGenerationTask.unclutter(this.getFileContent(this.outputFile));
        Objects.requireNonNull(previousOutput, "Could not read any content from file " + this.outputFile);
        chat.assistantMsg(previousOutput);
        chat.userMsg(question);
        String result = chat.execute();
        LOG.info(() -> "Explanation result for " + outputRelPath + " with question " + question + " is:\n" + result);
        if (result.contains(FIXME)) {
            throw new IllegalStateException("AI returned FIXME for " + outputRelPath + " :\n" + result);
        }
        return result;
    }

    public String toString() {
        return "AIGenerationTask{inputFiles=" + this.inputFiles + ", outputFile=" + this.outputFile + ", systemMessageFile=" + this.systemMessageFile + ", systemMessage='" + this.systemMessage + "', promptFiles=" + this.promptFiles + ", placeholdersAndValues=" + this.placeholdersAndValues + ", prompt='" + this.prompt + "'}";
    }

    public void force(boolean force) {
        this.force = force;
    }
}

