/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.stile.version.range;

import javax.inject.Inject;
import net.stickycode.exception.Preconditions;
import net.stickycode.stile.version.Bound;
import net.stickycode.stile.version.VersionRange;
import net.stickycode.stile.version.VersionRangeParser;
import net.stickycode.stile.version.component.ComponentVersionParser;
import net.stickycode.stile.version.range.ComponentVersionRange;
import net.stickycode.stile.version.range.ExclusiveBound;
import net.stickycode.stile.version.range.InclusiveBound;
import net.stickycode.stile.version.range.InvalidVersionRangeSpecificationException;
import net.stickycode.stile.version.range.VersionRangeMissingBoundException;
import net.stickycode.stile.version.range.VersionRangeMissingCommaException;

public class ComponentVersionRangeParser
implements VersionRangeParser {
    @Inject
    ComponentVersionParser parser;

    @Override
    public VersionRange parseVersionRange(String specification) {
        String versionRange = Preconditions.notBlank((String)specification, (String)"Version range specification cannot be blank");
        int comma = versionRange.indexOf(44);
        if (comma == -1) {
            throw new VersionRangeMissingCommaException(versionRange);
        }
        if (comma < 2 || comma > versionRange.length() - 3) {
            throw new VersionRangeMissingBoundException(versionRange);
        }
        Bound lowerBound = this.parseLowerBound(versionRange, comma);
        Bound upperBound = this.parseUpperBound(versionRange, comma);
        return new ComponentVersionRange(lowerBound, upperBound);
    }

    private Bound parseUpperBound(String versionRange, int comma) {
        char upperContraint = versionRange.charAt(versionRange.length() - 1);
        if (']' == upperContraint) {
            return new InclusiveBound(this.parser.parse(versionRange.substring(comma + 1, versionRange.length() - 1)));
        }
        if (')' == upperContraint) {
            return new ExclusiveBound(this.parser.parse(versionRange.substring(comma + 1, versionRange.length() - 1)));
        }
        throw new InvalidVersionRangeSpecificationException(versionRange, upperContraint);
    }

    private Bound parseLowerBound(String versionRange, int comma) {
        char lowerConstraint = versionRange.charAt(0);
        if ('[' == lowerConstraint) {
            return new InclusiveBound(this.parser.parse(versionRange.substring(1, comma)));
        }
        if ('(' == lowerConstraint) {
            return new ExclusiveBound(this.parser.parse(versionRange.substring(1, comma)));
        }
        throw new InvalidVersionRangeSpecificationException(lowerConstraint, versionRange);
    }
}

