/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.stile.version.component;

import java.util.Iterator;
import net.stickycode.exception.Preconditions;
import net.stickycode.stile.version.component.CharacterVersionString;
import net.stickycode.stile.version.component.InvalidVersionStringException;
import net.stickycode.stile.version.component.NumericVersionString;
import net.stickycode.stile.version.component.VersionString;

public class VersionStringSpliterator
implements Iterator<VersionString> {
    private final CharSequence source;
    private int position = 0;

    public VersionStringSpliterator(String source) {
        this.source = Preconditions.notBlank((String)source, (String)"Source cannot be blank");
    }

    @Override
    public boolean hasNext() {
        return this.position < this.source.length();
    }

    @Override
    public VersionString next() {
        VersionString nextSeparator = this.nextSeparator();
        this.position = nextSeparator.getEnd();
        return nextSeparator;
    }

    private VersionString nextSeparator() {
        int start = this.position;
        while (this.isSeparator(this.source.charAt(start))) {
            if (++start != this.source.length()) continue;
            throw new RuntimeException("ug");
        }
        if (Character.isDigit(this.source.charAt(start))) {
            return this.nextNumeric(start);
        }
        return this.nextCharacter(start);
    }

    private VersionString nextNumeric(int start) {
        int end = start;
        while (Character.isDigit(this.source.charAt(end))) {
            if (++end < this.source.length()) continue;
            return new NumericVersionString(this.source, this.position, start, end);
        }
        return new NumericVersionString(this.source, this.position, start, end);
    }

    private VersionString nextCharacter(int start) {
        int end = start;
        while (Character.isLetter(this.source.charAt(end))) {
            if (++end < this.source.length()) continue;
            return new CharacterVersionString(this.source, this.position, start, end);
        }
        if (end == start) {
            throw new InvalidVersionStringException(this.source, start);
        }
        return new CharacterVersionString(this.source, this.position, start, end);
    }

    private boolean isSeparator(char charAt) {
        switch (charAt) {
            case ' ': 
            case '-': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Iterating a version string is immutable");
    }
}

