/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.stile.version.component;

import net.stickycode.stile.version.component.CharacterVersionString;
import net.stickycode.stile.version.component.NumericVersionString;

public abstract class VersionString
implements CharSequence {
    private final CharSequence source;
    private final int separator;
    private final int start;
    private final int end;

    public VersionString(CharSequence source, int separator, int start, int end) {
        if (separator == end || start == end) {
            throw new RuntimeException("Invalidate version spec " + source);
        }
        this.source = source;
        this.separator = separator;
        this.start = start;
        this.end = end;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        return this.source.charAt(this.start + index);
    }

    @Override
    public CharSequence subSequence(int i, int k) {
        return this.source.subSequence(this.start + i, this.start + k);
    }

    abstract boolean isNumber();

    abstract boolean isString();

    int getEnd() {
        return this.end;
    }

    boolean hasSeparator() {
        return this.start > this.separator;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        return ((Object)this.source.subSequence(this.start, this.end)).toString();
    }

    public String fullString() {
        return ((Object)this.source.subSequence(this.separator, this.end)).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionString)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public String getSeparator() {
        return ((Object)this.source.subSequence(this.separator, this.start)).toString();
    }

    public NumericVersionString asNumeric() {
        throw new IllegalStateException();
    }

    public CharacterVersionString asCharacter() {
        throw new IllegalStateException();
    }

    public boolean isQualifier() {
        return false;
    }
}

