/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.stile.version.component;

import net.stickycode.exception.Preconditions;
import net.stickycode.stile.version.VersionParser;
import net.stickycode.stile.version.component.ComponentOrdering;
import net.stickycode.stile.version.component.ComponentVersion;
import net.stickycode.stile.version.component.NumericVersionComponent;
import net.stickycode.stile.version.component.StringVersionComponent;
import net.stickycode.stile.version.component.VersionString;
import net.stickycode.stile.version.component.VersionStringSpliterable;

public class ComponentVersionParser
implements VersionParser {
    @Override
    public ComponentVersion parse(String versionString) {
        return this.process(Preconditions.notBlank((String)versionString, (String)"Version spec cannot be blank"));
    }

    private ComponentVersion process(String versionString) {
        ComponentVersion v = new ComponentVersion();
        for (VersionString s : new VersionStringSpliterable(versionString)) {
            if (s.isNumber()) {
                v.add(new NumericVersionComponent(s.asNumeric()));
                continue;
            }
            if (v.last() == null) {
                v.add(new StringVersionComponent(s.asCharacter()));
                continue;
            }
            ComponentOrdering ordering = ComponentOrdering.fromCode(s.toString());
            if (ordering == null) {
                v.add(new StringVersionComponent(s.asCharacter()));
                continue;
            }
            v.last().qualify(ordering, s.asCharacter());
        }
        return v;
    }
}

