/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.stile.version.component;

import java.util.Iterator;
import net.stickycode.stile.version.Version;
import net.stickycode.stile.version.component.AbstractVersionComponent;
import net.stickycode.stile.version.component.LinkedIterator;

public class ComponentVersion
implements Iterable<AbstractVersionComponent>,
Version {
    private AbstractVersionComponent head;
    private AbstractVersionComponent last;

    @Override
    public Iterator<AbstractVersionComponent> iterator() {
        return new LinkedIterator<AbstractVersionComponent>(this.head);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (AbstractVersionComponent component : this) {
            result = 31 * result + component.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Iterator<AbstractVersionComponent> i = ((ComponentVersion)obj).iterator();
        for (AbstractVersionComponent component : this) {
            if (!i.hasNext()) {
                return false;
            }
            if (component.equals(i.next())) continue;
            return false;
        }
        return !i.hasNext();
    }

    @Override
    public int compareTo(Version o) {
        if (this == o) {
            return 0;
        }
        if (this.getClass() != o.getClass()) {
            throw new RuntimeException(this.getClass() + " != " + o.getClass());
        }
        Iterator<AbstractVersionComponent> other = ((ComponentVersion)o).iterator();
        for (AbstractVersionComponent t : this) {
            if (!other.hasNext()) {
                return 1;
            }
            int compare = t.compareTo(other.next());
            if (compare == 0) continue;
            return compare;
        }
        if (other.hasNext()) {
            return -1;
        }
        return 0;
    }

    public AbstractVersionComponent last() {
        return this.last;
    }

    public void add(AbstractVersionComponent component) {
        if (null == this.head) {
            this.head = component;
        } else {
            this.last.setNext(component);
        }
        this.last = component;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (AbstractVersionComponent component : this) {
            b.append(component.fullString());
        }
        return b.toString();
    }
}

