/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.stile.version.component;

import net.stickycode.exception.Preconditions;
import net.stickycode.stile.version.component.CharacterVersionString;
import net.stickycode.stile.version.component.ComponentOrdering;
import net.stickycode.stile.version.component.Linked;
import net.stickycode.stile.version.component.VersionString;

public abstract class AbstractVersionComponent
implements Comparable<AbstractVersionComponent>,
Linked<AbstractVersionComponent> {
    private AbstractVersionComponent next;
    private final VersionString versionString;
    private CharacterVersionString qualifier;
    private ComponentOrdering ordering = ComponentOrdering.Release;

    public AbstractVersionComponent(VersionString versionString) {
        this.versionString = (VersionString)Preconditions.notNull((Object)versionString, (String)"Version specification cannot be null");
    }

    @Override
    public int compareTo(AbstractVersionComponent o) {
        int compareVersionString = this.versionString.toString().compareTo(o.versionString.toString());
        if (compareVersionString != 0) {
            return compareVersionString;
        }
        return this.getOrdering().compareTo(o.getOrdering());
    }

    public ComponentOrdering getOrdering() {
        return this.ordering;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.valueHashCode();
        return result;
    }

    protected abstract int valueHashCode();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.valueEquals(obj);
    }

    protected abstract boolean valueEquals(Object var1);

    @Override
    public AbstractVersionComponent getNext() {
        return this.next;
    }

    @Override
    public void setNext(AbstractVersionComponent component) {
        this.next = component;
    }

    public String toString() {
        if (this.qualifier != null) {
            return this.versionString.toString() + this.qualifier.toString();
        }
        return this.versionString.toString();
    }

    public String fullString() {
        if (this.qualifier != null) {
            return this.versionString.fullString() + this.qualifier.fullString();
        }
        return this.versionString.fullString();
    }

    public void qualify(ComponentOrdering ordering, CharacterVersionString qualifier) {
        this.qualifier = qualifier;
        this.ordering = ordering;
    }
}

