/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.scheduled.guice4;

import com.google.inject.MembersInjector;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import javax.inject.Inject;
import net.stickycode.scheduled.guice4.ScheduledInjector;
import net.stickycode.stereotype.StickyComponent;
import net.stickycode.stereotype.StickyFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StickyComponent
@StickyFramework
public class ScheduledTypeListener
implements TypeListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private ScheduledInjector membersInjector;

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        if (this.membersInjector == null) {
            this.log.debug("ignoring {} for scheduling as members injector not injected yet, perhaps you need a child injector", type);
            return;
        }
        if (this.membersInjector.isApplicable(type.getRawType())) {
            encounter.register((MembersInjector)this.membersInjector);
            this.log.info("encountering {} registering injector {}", type, (Object)this.membersInjector);
        }
    }
}

