/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.deploy.bootstrap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.stickycode.deploy.bootstrap.StickyClasspath;
import net.stickycode.deploy.bootstrap.StickyLibrary;
import net.stickycode.deploy.bootstrap.StickyLogger;

public class ZipScanningStickyClasspath
implements StickyClasspath {
    private StickyLogger log = StickyLogger.getLogger(this.getClass());
    private List<StickyLibrary> libraries = new ArrayList<StickyLibrary>();
    private Map<String, StickyLibrary> lookup = new HashMap<String, StickyLibrary>();
    private int mainCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StickyClasspath loadZip(File application) {
        try {
            ZipFile file = new ZipFile(application);
            try {
                this.loadEntries(file);
            }
            finally {
                file.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    protected void loadEntries(ZipFile applicationFile) {
        for (ZipEntry zipEntry : this.listZipEntries(applicationFile)) {
            if (!zipEntry.getName().endsWith(".jar")) continue;
            this.log.info("Loading jar %s", zipEntry.getName());
            StickyLibrary library = new StickyLibrary(zipEntry.getName());
            this.libraries.add(library);
            this.lookup.put(zipEntry.getName(), library);
            this.indexLibrary(applicationFile, library);
        }
    }

    private List<ZipEntry> listZipEntries(ZipFile applicationFile) {
        return Collections.list(applicationFile.entries());
    }

    private void indexLibrary(ZipFile applicationFile, StickyLibrary library) {
        ZipEntry jar = applicationFile.getEntry(library.getJarPath());
        try {
            this.processEntry(applicationFile, jar, library);
            this.log.debug("Found %s classes and %s resources in jar %s", library.getClasses().size(), library.getResources().size(), library);
        }
        catch (IOException e) {
            this.log.error("failed to load", e);
        }
    }

    private void processEntry(ZipFile applicationFile, ZipEntry jar, StickyLibrary library) throws IOException {
        JarInputStream i = new JarInputStream(applicationFile.getInputStream(jar));
        this.processManifest(i, library);
        JarEntry current = i.getNextJarEntry();
        while (current != null) {
            if (!current.isDirectory()) {
                library.add(current.getName());
            }
            i.closeEntry();
            current = i.getNextJarEntry();
        }
        i.closeEntry();
    }

    private void processManifest(JarInputStream i, StickyLibrary library) {
        String mainClass;
        Manifest manifest = i.getManifest();
        if (manifest != null && (mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS)) != null) {
            library.addMain(mainClass);
            ++this.mainCount;
        }
    }

    @Override
    public List<StickyLibrary> getLibraries() {
        return this.libraries;
    }

    @Override
    public StickyLibrary getLibrary(String path) {
        return this.lookup.get(path);
    }

    @Override
    public boolean hasSingularMain() {
        return this.mainCount == 1;
    }

    @Override
    public String getSingularMain() {
        for (StickyLibrary l : this.libraries) {
            if (!l.hasMainClass()) continue;
            return l.getMainClass();
        }
        throw new RuntimeException("Should have a main but can't find it");
    }

    @Override
    public List<StickyLibrary> getLibrariesByMain(String shortName) {
        for (StickyLibrary l : this.libraries) {
            if (!l.hasMainClass() || !l.getMainClass().endsWith(shortName)) continue;
            return Collections.singletonList(l);
        }
        return Collections.emptyList();
    }
}

