/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.deploy.bootstrap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.stickycode.deploy.bootstrap.StickyLogger;
import net.stickycode.deploy.bootstrap.TheEntryBeingLoadedWasBiggerThan2GWhichSeemsWrongException;
import net.stickycode.deploy.bootstrap.TheUncompressedSizeListedInJarIsGreaterThan2GbWhichSeemsWrongException;

public class StickyLibrary {
    private StickyLogger log = StickyLogger.getLogger(this.getClass());
    private final String jarPath;
    private final Collection<String> classes = new ArrayList<String>();
    private final Collection<String> resources = new ArrayList<String>();
    private String mainClass;

    public StickyLibrary(String jarPath) {
        this.jarPath = jarPath;
    }

    public String toString() {
        return this.jarPath;
    }

    void add(String name) {
        if (name.endsWith(".class")) {
            this.addClass(name.substring(0, name.length() - 6).replace('/', '.'));
        } else {
            this.addResource(name);
        }
    }

    private boolean addResource(String name) {
        return this.resources.add(name);
    }

    private void addClass(String name) {
        this.classes.add(name);
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public Collection<String> getClasses() {
        return this.classes;
    }

    public Collection<String> getResources() {
        return this.resources;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(ClassLoader loader, String path) {
        InputStream inputStream;
        URL url = this.getJarStream(loader);
        JarInputStream jar = new JarInputStream(url.openStream());
        try {
            inputStream = this.loadStream(jar, path);
        }
        catch (Throwable throwable) {
            try {
                jar.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        jar.close();
        return inputStream;
    }

    URL getJarStream(ClassLoader loader) {
        URL url = loader.getResource(this.jarPath);
        if (url == null) {
            throw new RuntimeException("Where did " + this.jarPath + " go?");
        }
        return url;
    }

    private InputStream loadStream(JarInputStream jar, String path) throws IOException {
        JarEntry current = jar.getNextJarEntry();
        while (current != null) {
            if (!current.isDirectory() && current.getName().equals(path)) {
                return new ByteArrayInputStream(this.load(path, jar, current));
            }
            jar.closeEntry();
            current = jar.getNextJarEntry();
        }
        jar.closeEntry();
        return null;
    }

    private byte[] load(String name, JarInputStream in, JarEntry current) throws IOException {
        int size = this.deriveEntrySize(current);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
        byte[] buf = new byte[2048];
        while (baos.size() < 0x7FFFF7FF) {
            int len = in.read(buf);
            if (len < 0) {
                return baos.toByteArray();
            }
            baos.write(buf, 0, len);
        }
        throw new TheEntryBeingLoadedWasBiggerThan2GWhichSeemsWrongException(current.getName(), baos.size(), current.getCompressedSize(), current.getSize());
    }

    private int deriveEntrySize(JarEntry current) {
        if (current.getSize() >= Integer.MAX_VALUE) {
            throw new TheUncompressedSizeListedInJarIsGreaterThan2GbWhichSeemsWrongException(current.getName(), current.getCompressedSize(), current.getSize());
        }
        int size = (int)current.getSize();
        if (size < 0) {
            size = 2048;
        }
        return size;
    }

    public boolean hasMainClass() {
        return this.mainClass != null;
    }

    void addMain(String mainClass) {
        this.mainClass = mainClass;
    }
}

