/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.deploy.bootstrap;

import java.io.File;
import java.io.InputStream;
import net.stickycode.deploy.bootstrap.PredefinedStickyClasspath;
import net.stickycode.deploy.bootstrap.StickyClasspath;
import net.stickycode.deploy.bootstrap.StickyEmbedder;
import net.stickycode.deploy.bootstrap.ZipScanningStickyClasspath;

public class StickyLauncher {
    void configure(String[] args) {
        for (String s : args) {
            if ("--launcher-debug".equals(s)) {
                System.setProperty("launcher.debug", "true");
            }
            if (!"--launcher-verbose".equals(s)) continue;
            System.setProperty("launcher.verbose", "true");
        }
    }

    StickyClasspath buildClasspath() {
        InputStream classpath = StickyLauncher.class.getClassLoader().getResourceAsStream("META-INF/sticky/application.classpath");
        if (classpath != null) {
            return new PredefinedStickyClasspath().load(classpath);
        }
        File application = new File(ZipScanningStickyClasspath.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        return new ZipScanningStickyClasspath().loadZip(application);
    }

    void embed(ClassLoader systemClassLoader, String[] args) {
        StickyEmbedder embedder = new StickyEmbedder(args);
        StickyClasspath buildClasspath = this.buildClasspath();
        embedder.initialise(systemClassLoader, buildClasspath);
        embedder.launch();
    }

    public static void main(String[] args) throws InterruptedException {
        StickyLauncher launcher = new StickyLauncher();
        launcher.configure(args);
        launcher.embed(ClassLoader.getSystemClassLoader(), args);
    }
}

