/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.deploy.bootstrap;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;
import net.stickycode.deploy.bootstrap.StickyClassLoader;
import net.stickycode.deploy.bootstrap.StickyClasspath;
import net.stickycode.deploy.bootstrap.StickyLibrary;
import net.stickycode.deploy.bootstrap.StickyLogger;

public class StickyEmbedder {
    private StickyLogger log = StickyLogger.getLogger(this.getClass());
    private final String[] args;
    private StickyClassLoader classLoader;
    private StickyClasspath classpath;
    private Pattern main = Pattern.compile("[A-Z][a-zA-Z0-9_]*");

    public StickyEmbedder(String ... args) {
        this.args = args;
    }

    public void initialise(ClassLoader loader, StickyClasspath classpath) {
        this.classpath = classpath;
        this.classLoader = new StickyClassLoader(loader, classpath);
    }

    public List<StickyLibrary> getLibraries() {
        return this.classpath.getLibraries();
    }

    public void launch() {
        try {
            this.launchClassExplosively("net.stickycode.deploy.Embedded");
        }
        catch (ClassNotFoundException e) {
            this.log.info("net.stickycode.deploy.Embedded not found", new Object[0]);
            this.loadByMain();
        }
    }

    private void loadByMain() {
        if (this.classpath.hasSingularMain()) {
            this.launchClass(this.classpath.getSingularMain());
        }
        for (String arg : this.args) {
            if (!this.main.matcher(arg).matches()) continue;
            for (StickyLibrary l : this.classpath.getLibrariesByMain(arg)) {
                this.launchClass(l.getMainClass());
            }
        }
    }

    private void launchClass(String className) {
        try {
            this.launchClassExplosively(className);
        }
        catch (ClassNotFoundException e1) {
            this.log.info(e1.getMessage(), new Object[0]);
        }
    }

    private void launchClassExplosively(String className) throws ClassNotFoundException {
        this.log.info("Attempting to load %s", className);
        Class<?> e = this.classLoader.loadClass(className);
        if (Runnable.class.isAssignableFrom(e)) {
            this.launchRunnable(this.classLoader, e);
        } else {
            this.launchMain(this.classLoader, e);
        }
    }

    private void launchMain(StickyClassLoader l, Class<?> klass) {
        this.log.info("Loading %s by main method with args %s", klass, this.args);
        try {
            Method main = klass.getMethod("main", String[].class);
            main.invoke(null, new Object[]{this.args});
        }
        catch (SecurityException e1) {
            throw new RuntimeException(e1);
        }
        catch (NoSuchMethodException e1) {
            throw new RuntimeException(e1);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void launchRunnable(StickyClassLoader l, Class<?> e) {
        Object[] parameters = new Object[]{};
        this.log.info("Loading net.stickycode.deploy.Embedded as Runnable", parameters);
        Runnable r = this.constructRunnable(e);
        Thread t = new Thread(r);
        t.setContextClassLoader(l);
        t.setDaemon(false);
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(e1);
        }
    }

    private Runnable constructRunnable(Class<?> e) {
        try {
            Object o = this.contructEmbedded(e);
            return (Runnable)Runnable.class.cast(o);
        }
        catch (InstantiationException e1) {
            throw new RuntimeException(e1);
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException(e1);
        }
    }

    private Object contructEmbedded(Class<?> embedded) throws InstantiationException, IllegalAccessException {
        try {
            Constructor<?> c = embedded.getConstructor(String[].class);
            return c.newInstance(new Object[]{this.args});
        }
        catch (SecurityException e1) {
            throw new RuntimeException(e1);
        }
        catch (NoSuchMethodException e1) {
            throw new RuntimeException(e1);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public StickyClassLoader getClassLoader() {
        return this.classLoader;
    }

    public StickyLibrary getLibrary(String jarPath) {
        for (StickyLibrary l : this.classpath.getLibraries()) {
            if (!l.getJarPath().equals(jarPath)) continue;
            return l;
        }
        throw new RuntimeException(jarPath + " not found");
    }
}

