/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.deploy.bootstrap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.stickycode.deploy.bootstrap.StickyClasspath;
import net.stickycode.deploy.bootstrap.StickyEmbeddedUrlStreamHandler;
import net.stickycode.deploy.bootstrap.StickyLibrary;
import net.stickycode.deploy.bootstrap.StickyLogger;
import net.stickycode.deploy.bootstrap.TheEntryBeingLoadedWasBiggerThan2GWhichSeemsWrongException;
import net.stickycode.deploy.bootstrap.TheUncompressedSizeListedInJarIsGreaterThan2GbWhichSeemsWrongException;

public class StickyClassLoader
extends ClassLoader {
    private StickyLogger log = StickyLogger.getLogger(this.getClass());
    private StickyEmbeddedUrlStreamHandler urlFactory;
    private StickyClasspath classpath;

    public StickyClassLoader(ClassLoader loader, StickyClasspath classpath) {
        super(loader);
        this.classpath = classpath;
        this.urlFactory = new StickyEmbeddedUrlStreamHandler(classpath, loader);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        this.log.debug("looking up class %s", name);
        for (StickyLibrary j : this.classpath.getLibraries()) {
            if (!j.getClasses().contains(name)) continue;
            this.log.debug("loading %s from %s", name, j);
            return this.loadClass(j, name);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        Object[] parameters = new Object[]{name};
        this.log.debug("Looking up resource %s", parameters);
        for (StickyLibrary j : this.classpath.getLibraries()) {
            if (!j.getResources().contains(name)) continue;
            URL url = this.urlFactory.createResourceUrl(name, j);
            this.log.info("define url %s for %s in %s", url, name, j);
            return url;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        LinkedList<URL> list = new LinkedList<URL>();
        Object[] parameters = new Object[]{name};
        this.log.debug("Looking up resources %s", parameters);
        for (StickyLibrary j : this.classpath.getLibraries()) {
            if (!j.getResources().contains(name)) continue;
            URL url = this.urlFactory.createResourceUrl(name, j);
            this.log.info("define url %s for %s in %s", url, name, j);
            list.add(url);
        }
        return Collections.enumeration(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClass(StickyLibrary j, String name) throws ClassNotFoundException {
        Class<?> clazz;
        URL url = j.getJarStream(this.getParent());
        InputStream openStream = url.openStream();
        try {
            JarInputStream jar = new JarInputStream(openStream);
            clazz = this.loadClass(jar, name);
        }
        catch (Throwable throwable) {
            try {
                openStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Failed to load " + name, e);
            }
        }
        openStream.close();
        return clazz;
    }

    private Class<?> loadClass(JarInputStream i, String name) throws IOException {
        String searchFor = name.replace('.', '/') + ".class";
        JarEntry current = i.getNextJarEntry();
        while (current != null) {
            if (!current.isDirectory() && current.getName().equals(searchFor)) {
                return this.load(name, i, current);
            }
            i.closeEntry();
            current = i.getNextJarEntry();
        }
        return null;
    }

    private Class<?> load(String name, JarInputStream i, JarEntry current) throws IOException {
        byte[] b = this.copy(i, current);
        return this.defineClass(name, b, 0, b.length);
    }

    protected byte[] copy(InputStream in, JarEntry current) throws IOException {
        int size = this.deriveClassSize(current);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
        byte[] buf = new byte[2048];
        while (baos.size() < 0x7FFFF7FF) {
            int len = in.read(buf);
            if (len < 0) {
                return baos.toByteArray();
            }
            baos.write(buf, 0, len);
        }
        throw new TheEntryBeingLoadedWasBiggerThan2GWhichSeemsWrongException(current.getName(), baos.size(), current.getCompressedSize(), current.getSize());
    }

    private int deriveClassSize(JarEntry current) {
        if (current.getSize() >= Integer.MAX_VALUE) {
            throw new TheUncompressedSizeListedInJarIsGreaterThan2GbWhichSeemsWrongException(current.getName(), current.getCompressedSize(), current.getSize());
        }
        int size = (int)current.getSize();
        if (size < 0) {
            size = 2048;
        }
        return size;
    }
}

