/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.deploy.bootstrap;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.stickycode.deploy.bootstrap.LineIterable;
import net.stickycode.deploy.bootstrap.StickyClasspath;
import net.stickycode.deploy.bootstrap.StickyLibrary;
import net.stickycode.deploy.bootstrap.StickyLogger;

public class PredefinedStickyClasspath
implements StickyClasspath {
    private StickyLogger logger = StickyLogger.getLogger(this.getClass());
    private List<StickyLibrary> libraries = new ArrayList<StickyLibrary>();
    private Map<String, StickyLibrary> lookup = new HashMap<String, StickyLibrary>();
    private int mainCount = 0;

    StickyClasspath load(InputStream classpath) {
        StickyLibrary current = null;
        for (String line : new LineIterable(classpath)) {
            if (line.startsWith("!")) {
                current = this.foundLibrary(line.substring(1));
                continue;
            }
            if (line.startsWith("*")) {
                String main = line.substring(1);
                this.logger.debug("Found main %s", main);
                current.addMain(main);
                ++this.mainCount;
                continue;
            }
            current.add(line);
        }
        return this;
    }

    private StickyLibrary foundLibrary(String library) {
        this.logger.debug("Found index for %s", library);
        StickyLibrary current = new StickyLibrary(library);
        this.libraries.add(current);
        this.lookup.put(library, current);
        return current;
    }

    @Override
    public List<StickyLibrary> getLibraries() {
        return this.libraries;
    }

    @Override
    public StickyLibrary getLibrary(String path) {
        return this.lookup.get(path);
    }

    @Override
    public boolean hasSingularMain() {
        return this.mainCount == 1;
    }

    @Override
    public String getSingularMain() {
        for (StickyLibrary l : this.libraries) {
            if (!l.hasMainClass()) continue;
            return l.getMainClass();
        }
        throw new RuntimeException("Should have a main but can't find it");
    }

    @Override
    public List<StickyLibrary> getLibrariesByMain(String shortName) {
        for (StickyLibrary l : this.libraries) {
            if (!l.hasMainClass() || !l.getMainClass().endsWith(shortName)) continue;
            return Collections.singletonList(l);
        }
        return Collections.emptyList();
    }
}

