/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.deploy.bootstrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;

public class LineIterable
implements Iterable<String> {
    private InputStream in;

    public LineIterable(InputStream classpath) {
        this.in = classpath;
    }

    @Override
    public Iterator<String> iterator() {
        return new LineIterator(new BufferedReader(new InputStreamReader(this.in, Charset.forName("UTF-8"))));
    }

    public class LineIterator
    implements Iterator<String> {
        private final BufferedReader reader;
        private String nextLine;

        public LineIterator(BufferedReader bufferedReader) {
            this.reader = bufferedReader;
            this.nextLine = this.readLine();
        }

        private String readLine() {
            try {
                return this.reader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextLine != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String next() {
            try {
                String string = this.nextLine;
                return string;
            }
            finally {
                this.nextLine = this.readLine();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not implemented");
        }
    }
}

