/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.configured.spring3.finder;

import java.util.Map;
import javax.inject.Inject;
import net.stickycode.configured.finder.BeanFinder;
import net.stickycode.configured.finder.BeanNotFoundException;
import net.stickycode.stereotype.StickyComponent;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

@StickyComponent
public class SpringBeanFinder
implements BeanFinder {
    @Inject
    private ApplicationContext context;

    public <T> T find(Class<T> type) throws BeanNotFoundException {
        try {
            return (T)this.context.getBean(type);
        }
        catch (NoSuchBeanDefinitionException e) {
            try {
                Map beans = this.context.getBeansOfType(type);
                if (beans.values().isEmpty()) {
                    throw new BeanNotFoundException((Exception)((Object)e), type);
                }
                throw new BeanNotFoundException(type, beans.values());
            }
            catch (NoSuchBeanDefinitionException e2) {
                throw new BeanNotFoundException((Exception)((Object)e2), type);
            }
        }
    }
}

