/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.configured.spring3;

import javax.inject.Inject;
import net.stickycode.configured.ConfiguredBeanProcessor;
import net.stickycode.metadata.MetadataResolverRegistry;
import net.stickycode.stereotype.StickyComponent;
import net.stickycode.stereotype.configured.Configured;
import net.stickycode.stereotype.configured.ConfiguredStrategy;
import net.stickycode.stereotype.configured.PostConfigured;
import net.stickycode.stereotype.configured.PreConfigured;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;

@StickyComponent
public class ConfiguredBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    @Inject
    private ConfiguredBeanProcessor processor;
    @Inject
    MetadataResolverRegistry metdataResolverRegistry;

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        if (this.typeIsConfigured(bean.getClass())) {
            this.processor.process(bean);
        }
        return true;
    }

    private boolean typeIsConfigured(Class<?> type) {
        if (this.metdataResolverRegistry.does(type).haveAnyFieldsMetaAnnotatedWith(new Class[]{Configured.class, ConfiguredStrategy.class})) {
            return true;
        }
        return this.metdataResolverRegistry.does(type).haveAnyMethodsMetaAnnotatedWith(new Class[]{PreConfigured.class, PostConfigured.class});
    }
}

