/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.guice3;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Stage;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import de.devsurf.injection.guice.scanner.PackageFilter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import net.stickycode.configured.ConfigurationSystem;
import net.stickycode.configured.guice3.StickyModule;
import net.stickycode.cxf.guice3.StickyCxfServlet;
import net.stickycode.guice3.jsr250.Jsr250Module;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class StickyGuiceContextListener
extends GuiceServletContextListener {
    private Logger log = LoggerFactory.getLogger(StickyGuiceContextListener.class);
    @Inject
    ConfigurationSystem configuration;

    protected Injector getInjector() {
        this.log.info("building injector");
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{StickyModule.bootstrapModule((PackageFilter[])new PackageFilter[]{PackageFilter.create((String)"net.stickycode")}), StickyModule.keyBuilderModule(), this.cxfModule()}).createChildInjector(new Module[]{StickyModule.applicationModule((PackageFilter[])new PackageFilter[]{PackageFilter.create((String)"net.stickycode")}), this.servletModule()});
        injector.injectMembers((Object)this);
        return injector;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        Injector injector = this.getInjector();
        servletContext.setAttribute(Injector.class.getName(), (Object)injector);
        this.configure();
    }

    void configure() {
        this.log.info("configuring");
        this.configuration.configure();
        this.log.info("configured");
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        Injector injector = (Injector)servletContextEvent.getServletContext().getAttribute(Injector.class.getName());
        this.shutdown(injector);
        super.contextDestroyed(servletContextEvent);
    }

    void shutdown(Injector injector) {
        Jsr250Module.preDestroy((Logger)this.log, (Injector)injector);
    }

    private Module cxfModule() {
        return new AbstractModule(){

            protected void configure() {
                this.bind(StickyCxfServlet.class).asEagerSingleton();
                this.bind(Bus.class).toProvider((Provider)new Provider<Bus>(){

                    public Bus get() {
                        return BusFactory.newInstance().createBus();
                    }
                }).asEagerSingleton();
            }
        };
    }

    private ServletModule servletModule() {
        return new ServletModule(){

            protected void configureServlets() {
                this.serve("/services/*", new String[0]).with(StickyCxfServlet.class);
                this.serve("/*", new String[0]).with(StickyCxfServlet.class);
            }
        };
    }

    static {
        java.util.logging.Logger util = LogManager.getLogManager().getLogger("");
        for (Handler handler : util.getHandlers()) {
            util.removeHandler(handler);
        }
        SLF4JBridgeHandler.install();
    }
}

