/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.cxf.guice3;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import javax.inject.Inject;
import javax.jws.WebService;
import net.stickycode.cxf.guice3.WebServiceCollector;
import net.stickycode.stereotype.StickyComponent;
import net.stickycode.stereotype.StickyFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StickyComponent
@StickyFramework
public class WebServiceTypeListener
implements TypeListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private WebServiceCollector collector;

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        if (this.isWebService(type)) {
            if (this.collector == null) {
                throw new AssertionError((Object)("on hearing " + type.getRawType().getName() + " found that " + this.getClass().getSimpleName() + " was not injected with a " + WebServiceCollector.class.getSimpleName()));
            }
            encounter.register((InjectionListener)this.collector);
            this.log.info("encountering {} registering injector {}", type, (Object)this.collector);
        }
    }

    private <I> boolean isWebService(TypeLiteral<I> type) {
        for (Class<?> i : type.getRawType().getInterfaces()) {
            if (!i.isAnnotationPresent(WebService.class)) continue;
            return true;
        }
        return false;
    }
}

