/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.bootstrap.spring3;

import java.util.Collection;
import javax.inject.Provider;
import javax.inject.Singleton;
import net.stickycode.bootstrap.StickyBootstrap;
import net.stickycode.bootstrap.StickySystemStartup;
import net.stickycode.bootstrap.spring3.DisposableBeanAdapter;
import net.stickycode.bootstrap.spring3.FactoryBeanProviderAdapter;
import net.stickycode.bootstrap.spring3.SpringComponentContainer;
import net.stickycode.bootstrap.spring3.StickyScopeMetadataResolver;
import net.stickycode.bootstrap.spring3.VersionedBeanNameGenerator;
import net.stickycode.stereotype.StickyComponent;
import net.stickycode.stereotype.StickyDomain;
import net.stickycode.stereotype.StickyPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;

public class Spring3StickyBootstrap
implements StickyBootstrap {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private GenericApplicationContext context;

    public Spring3StickyBootstrap() {
        this(new GenericApplicationContext());
    }

    public Spring3StickyBootstrap(GenericApplicationContext context) {
        this.context = context;
        AutowiredAnnotationBeanPostProcessor inject = new AutowiredAnnotationBeanPostProcessor();
        inject.setBeanFactory((BeanFactory)context.getDefaultListableBeanFactory());
        context.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)inject);
        CommonAnnotationBeanPostProcessor commonPostProcessor = new CommonAnnotationBeanPostProcessor();
        commonPostProcessor.setBeanFactory((BeanFactory)context.getDefaultListableBeanFactory());
        context.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)commonPostProcessor);
        this.registerType("componentContainer", SpringComponentContainer.class);
    }

    public Spring3StickyBootstrap(String ... paths) {
        this(new GenericApplicationContext());
        if (paths != null && paths.length > 0) {
            this.scan(paths);
        }
    }

    public StickyBootstrap scan(String ... paths) {
        if (paths.length > 0) {
            ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)this.context, false);
            scanner.setBeanNameGenerator((BeanNameGenerator)new VersionedBeanNameGenerator());
            scanner.setScopeMetadataResolver((ScopeMetadataResolver)new StickyScopeMetadataResolver());
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(StickyComponent.class));
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(StickyPlugin.class));
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(StickyDomain.class));
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Component.class));
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Singleton.class));
            scanner.scan(paths);
        }
        return this;
    }

    public AutowireCapableBeanFactory getAutowirer() {
        return this.getContext().getAutowireCapableBeanFactory();
    }

    private GenericApplicationContext getContext() {
        if (!this.context.isActive()) {
            this.context.refresh();
        }
        return this.context;
    }

    public StickyBootstrap inject(Object value) {
        this.getAutowirer().autowireBean(value);
        return this;
    }

    public <T> T find(Class<T> type) {
        return (T)this.getContext().getBean(type);
    }

    public boolean canFind(Class<?> type) {
        return this.context.getBeanNamesForType(type).length > 0;
    }

    public Object getImplementation() {
        return this.context;
    }

    public void registerSingleton(String beanName, Object bean, Class<?> type) {
        this.log.debug("registering bean '{}' of type '{}'", (Object)beanName, (Object)type.getName());
        this.context.getBeanFactory().initializeBean(bean, beanName);
        this.context.getBeanFactory().registerSingleton(beanName, bean);
        this.context.getDefaultListableBeanFactory().registerDisposableBean(beanName, (DisposableBean)new DisposableBeanAdapter(bean, beanName, this.context));
    }

    public void registerType(String beanName, Class<?> type) {
        this.log.debug("registering definition '{}' for type '{}'", (Object)beanName, (Object)type.getName());
        GenericBeanDefinition bd = new GenericBeanDefinition();
        bd.setBeanClass(type);
        bd.setAutowireMode(2);
        this.context.getDefaultListableBeanFactory().registerBeanDefinition(beanName, (BeanDefinition)bd);
    }

    public void shutdown() {
        if (this.context.isRunning() && this.canFind(StickySystemStartup.class)) {
            this.find(StickySystemStartup.class).shutdown();
        }
        this.context.close();
    }

    public StickyBootstrap scan(Collection<String> packageFilters) {
        this.scan(packageFilters.toArray(new String[packageFilters.size()]));
        return this;
    }

    public void extend(Object extension) {
        if (extension instanceof Class) {
            Class type = (Class)extension;
            this.registerType(type.getSimpleName(), type);
        } else {
            this.registerSingleton(extension.getClass().getSimpleName(), extension, extension.getClass());
        }
    }

    public void start() {
        if (this.canFind(StickySystemStartup.class)) {
            this.find(StickySystemStartup.class).start();
        }
    }

    public void registerProvider(String name, Provider<Object> provider, Class<?> type) {
        this.context.getBeanFactory().registerSingleton(name, (Object)new FactoryBeanProviderAdapter(provider, type));
    }
}

