/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.bootstrap.spring3;

import javax.inject.Inject;
import net.stickycode.bootstrap.StickyBootstrap;
import org.assertj.core.api.StrictAssertions;
import org.junit.Test;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.GenericApplicationContext;

public class BeanFactoryPostProcessorTest {
    @Inject
    private Example example;

    @Test
    public void empty() {
        StickyBootstrap crank = StickyBootstrap.crank();
        GenericApplicationContext context = (GenericApplicationContext)crank.getImplementation();
        StrictAssertions.assertThat((int)context.getBeanDefinitionCount()).isEqualTo(1);
    }

    @Test
    public void checkBeanFactoryPostProcessors() {
        StickyBootstrap crank = StickyBootstrap.crank();
        GenericApplicationContext context = (GenericApplicationContext)crank.getImplementation();
        StrictAssertions.assertThat((int)context.getBeanDefinitionCount()).isEqualTo(1);
        context.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                StrictAssertions.assertThat((int)beanFactory.getBeanNamesForType(Example.class).length).isGreaterThan(0);
            }
        });
        crank.registerSingleton("bob", (Object)new Example(), Example.class);
        crank.inject((Object)this);
    }

    public class Example {
        private String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

