/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.picheese.pojos.v1;

import net.stepniak.picheese.pojos.Base;

public class CollectionBase
extends Base {
    private int currentPage;
    private int pageLimit;
    private int totalResults;
    private int totalPages;
    private boolean isNext;
    private int nextPage;
    private boolean isPrev;
    private int prevPage;

    public CollectionBase() {
    }

    public CollectionBase(int currentPage, int pageLimit, int totalResults) {
        this.currentPage = currentPage;
        this.pageLimit = pageLimit;
        this.totalResults = totalResults;
        this.totalPages = (int)Math.ceil((double)totalResults / (double)pageLimit);
        this.isNext = this.totalPages > currentPage;
        this.nextPage = this.isNext ? currentPage + 1 : currentPage;
        this.isPrev = currentPage > 1;
        this.prevPage = this.isPrev ? currentPage - 1 : 0;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPageLimit() {
        return this.pageLimit;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public boolean getIsNext() {
        return this.isNext;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public boolean getIsPrev() {
        return this.isPrev;
    }

    public int getPrevPage() {
        return this.prevPage;
    }
}

