/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.picheese.error.client;

import net.stepniak.picheese.error.client.exception.AuthException;
import net.stepniak.picheese.error.client.exception.ConnectionFailedException;
import net.stepniak.picheese.error.client.exception.InputParamException;
import net.stepniak.picheese.error.client.exception.UpdateApplicationException;
import net.stepniak.picheese.error.server.exception.ImageException;

public enum ClientErrorType {
    MAINTENANCE_BREAK("Maintenance break, please try later", UpdateApplicationException.class),
    UPDATE_APPLICATION("You should update application", UpdateApplicationException.class),
    CONNECTION_FAILED("Connection problem, try again", ConnectionFailedException.class),
    AUTH_FAILED("Authentication problem", AuthException.class),
    AUTH_USER_REQUIRED("You must be logged in", AuthException.class),
    UPLOAD_FAILED("Unable to send image", ImageException.class),
    MISSING_REQUIRED_PARAMS("Missing required param", ImageException.class),
    MISSING_EMAIL_PARAM("Missing email", InputParamException.class),
    INVALID_EMAIL_PARAM("Invalid email", InputParamException.class),
    LENGTH_EMAIL_PARAM(String.format("Email too long (max %d chars).", 100), InputParamException.class),
    MISSING_USERNAME_PARAM("Missing username", InputParamException.class),
    INVALID_USERNAME_PARAM("Invalid username", InputParamException.class),
    LENGTH_USERNAME_PARAM(String.format("Username too long (max %d chars).", 50), InputParamException.class),
    MISSING_PHOTO_PARAM("You must select photo to upload", InputParamException.class),
    INVALID_PHOTO_PARAM("Invalid photo", InputParamException.class),
    MISSING_PHOTO_URL_PARAM("Missing photo url", InputParamException.class),
    INVALID_PHOTO_URL_PARAM("Invalid photo url", InputParamException.class),
    MISSING_DESCRIPTION_PARAM("Missing description", InputParamException.class),
    INVALID_DESCRIPTION_PARAM("Invalid description", InputParamException.class),
    LENGTH_DESCRIPTION_PARAM(String.format("Description is too long (max %d chars).", 255), InputParamException.class),
    MISSING_TITLE_PARAM("Missing title", InputParamException.class),
    INVALID_TITLE_PARAM("Invalid title", InputParamException.class),
    LENGTH_TITLE_PARAM(String.format("Title param value too long (max %d chars).", 50), InputParamException.class);

    private final String msg;
    private final Class exceptionClass;

    private ClientErrorType(String msg, Class exceptionClass) {
        this.msg = msg;
        this.exceptionClass = exceptionClass;
    }

    public String getMsg() {
        return this.msg;
    }
}

