/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.picheese.error.server;

import java.util.HashMap;
import java.util.Map;
import net.stepniak.picheese.error.server.exception.BadRequestException;
import net.stepniak.picheese.error.server.exception.ForbiddenException;
import net.stepniak.picheese.error.server.exception.HttpsRequiredException;
import net.stepniak.picheese.error.server.exception.ImageException;
import net.stepniak.picheese.error.server.exception.InternalServerException;
import net.stepniak.picheese.error.server.exception.MethodNotAllowedException;
import net.stepniak.picheese.error.server.exception.NotAuthorizedException;
import net.stepniak.picheese.error.server.exception.NotFoundException;
import net.stepniak.picheese.error.server.exception.PhotoException;
import net.stepniak.picheese.error.server.exception.ServerBaseException;
import net.stepniak.picheese.error.server.exception.UnsupportedMediaTypeException;
import net.stepniak.picheese.error.server.exception.UserAuthException;

public enum ServerErrorType {
    METHOD_NOT_ALLOWED("Method not allowed, try using get/post/put instead", "METHOD_NOT_ALLOWED", MethodNotAllowedException.class),
    BAD_REQUEST("Something wrong with your request.", "BAD_REQUEST", BadRequestException.class),
    NOT_FOUND("Resource not found", "NOT_FOUND", NotFoundException.class),
    INTERNAL_EXCEPTION("Internal server error", "INTERNAL_EXCEPTION", InternalServerException.class),
    HTTPS_REQUIRED("Https is required to call this method", "HTTPS_REQUIRED", HttpsRequiredException.class),
    UNAUTHORIZED("You are not authorized to call this method", "UNAUTHORIZED", NotAuthorizedException.class),
    FORBIDDEN("You can not call this method", "FORBIDDEN", ForbiddenException.class),
    UNSUPPORTED_MEDIA_TYPE("Entity of the request is in a format not supported by the requested resource for the requested method", "UNSUPPORTED_MEDIA_TYPE", UnsupportedMediaTypeException.class),
    PARAM_KEY("Missing api key", "PARAM_KEY", BadRequestException.class),
    PARAM_SESSION_ID("Missing sessionId", "PARAM_SESSION_ID", BadRequestException.class),
    PARAM_IMAGE_BASE64("Unknown imgBase64 param value.", "PARAM_IMAGE_BASE64", BadRequestException.class),
    PARAM_URL("Unknown url param value.", "PARAM_URL", BadRequestException.class),
    PARAM_DESCRIPTION("Unknown description param value.", "PARAM_DESCRIPTION", BadRequestException.class),
    PARAM_DESCRIPTION_LENGTH(String.format("Description param value too long (max %d chars).", 255), "PARAM_DESCRIPTION_LENGTH", BadRequestException.class),
    PARAM_TITLE("Unknown title param value.", "PARAM_TITLE", BadRequestException.class),
    PARAM_TITLE_LENGTH(String.format("Title param value too long (max %d chars).", 50), "PARAM_TITLE_LENGTH", BadRequestException.class),
    PARAM_PAGE_NUMBER("Unknown page param value.", "PARAM_PAGE_NUMBER", BadRequestException.class),
    PARAM_PAGE_LIMIT("Unknown limit param value.", "PARAM_PAGE_LIMIT", BadRequestException.class),
    PARAM_RATE("Unknown rate param value (must be 1 or -1)", "PARAM_RATE", BadRequestException.class),
    PARAM_USER_EMAIL("Invalid email value", "PARAM_USER_EMAIL", BadRequestException.class),
    PARAM_USER_EMAIL_LENGTH(String.format("Email param value too long (max %d chars).", 100), "PARAM_USER_EMAIL_LENGTH", BadRequestException.class),
    PARAM_USER_NAME("Invalid userName value", "PARAM_USER_NAME", BadRequestException.class),
    PARAM_USER_NAME_LENGTH(String.format("UserName param value too long (max %d chars).", 50), "PARAM_USER_NAME_LENGTH", BadRequestException.class),
    INVALID_KEY("Invalid api key", "INVALID_KEY", NotAuthorizedException.class),
    UNAUTHORIZED_SESSION_ID("Unauthorized sessionId (anonymous user)", "UNAUTHORIZED_SESSION_ID", NotAuthorizedException.class),
    INVALID_SESSION_ID("Invalid sessionId", "INVALID_SESSION_ID", NotAuthorizedException.class),
    INVALID_AUTH_FOR_USER("Unable to authorize user by given email and userName", "INVALID_AUTH_FOR_USER", UserAuthException.class),
    USER_ALREADY_EXISTS("User already exists", "USER_ALREADY_EXISTS", ForbiddenException.class),
    ALREADY_RATED_PHOTO("Already rated photo", "ALREADY_RATED_PHOTO", PhotoException.class),
    IMAGE_MIME_TYPE("Given mime type is not supported", "IMAGE_MIME_TYPE", ImageException.class),
    IMAGE_CONTENT("Something wrong with image", "IMAGE_CONTENT", ImageException.class),
    IMAGE_CONTENT_SIZE("Image is too big", "IMAGE_CONTENT_SIZE", ImageException.class);

    private static Map<String, ServerErrorType> lookupByErrorCode;
    private final String msg;
    private final String errorCode;
    private final Class exceptionClass;

    private ServerErrorType(String msg, String errorCode, Class exceptionClass) {
        this.msg = msg;
        this.errorCode = errorCode;
        this.exceptionClass = exceptionClass;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void throwException() throws ServerBaseException {
        if (this.exceptionClass == BadRequestException.class) {
            throw new BadRequestException(this);
        }
        if (this.exceptionClass == ForbiddenException.class) {
            throw new ForbiddenException(this);
        }
        if (this.exceptionClass == HttpsRequiredException.class) {
            throw new HttpsRequiredException(this);
        }
        if (this.exceptionClass == ImageException.class) {
            throw new ImageException(this);
        }
        if (this.exceptionClass == InternalServerException.class) {
            throw new InternalServerException(this);
        }
        if (this.exceptionClass == MethodNotAllowedException.class) {
            throw new MethodNotAllowedException(this);
        }
        if (this.exceptionClass == NotAuthorizedException.class) {
            throw new NotAuthorizedException(this);
        }
        if (this.exceptionClass == NotFoundException.class) {
            throw new NotFoundException(this);
        }
        if (this.exceptionClass == PhotoException.class) {
            throw new PhotoException(this);
        }
        if (this.exceptionClass == UnsupportedMediaTypeException.class) {
            throw new UnsupportedMediaTypeException(this);
        }
        if (this.exceptionClass == UserAuthException.class) {
            throw new UserAuthException(this);
        }
    }

    public static ServerErrorType create(String errorCode) {
        return lookupByErrorCode.get(errorCode);
    }

    static {
        lookupByErrorCode = new HashMap<String, ServerErrorType>(ServerErrorType.values().length);
        for (ServerErrorType item : ServerErrorType.values()) {
            lookupByErrorCode.put(item.getErrorCode(), item);
        }
    }
}

