package net.stepniak.picheese.error.client.exception;

import net.stepniak.picheese.error.client.ClientErrorType;

public abstract class ClientBaseException extends RuntimeException {

  private Throwable cause;
  private ClientErrorType error;

  public ClientBaseException(ClientErrorType error) {
    this(error, null);
  }

  public ClientBaseException(ClientErrorType error, Throwable cause) {
    super(error.getMsg(), cause);
    this.error = error;
    this.cause = cause;
  }

  public Throwable getCause() {
    return cause;
  }

  public ClientErrorType getError() {
    return error;
  }
}