/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.response.exception;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.stepniak.api.json.JsonMapper;
import net.stepniak.common.error.http.InternalServerException;
import net.stepniak.common.error.http.ServerBaseException;
import net.stepniak.common.pojos.v1.Error;

public class BaseExceptionMapper {
    private static JsonMapper jsonMapper = new JsonMapper();

    public static JsonMapper getJsonMapper() {
        return jsonMapper;
    }

    protected StringBuilder getLogMessage(UriInfo uriInfo, Throwable cause) {
        StringBuilder msg = new StringBuilder();
        if (uriInfo != null) {
            msg.append(String.format("Request: \"%s\":", uriInfo.getRequestUri().toString().replaceFirst(uriInfo.getBaseUri().toString(), "/")));
        }
        if (cause != null && cause.getMessage() != null) {
            msg.append(String.format("Cause: \"%s\".", cause.getMessage()));
        }
        return msg;
    }

    protected Response prepareResponse(ServerBaseException exception) {
        Error error = new Error(exception, "USER_MESSAGE");
        return Response.status((int)exception.getStatus()).entity((Object)BaseExceptionMapper.getJsonMapper().toJson((Object)error)).build();
    }

    protected Response prepareInternalErrorResponse(Throwable exception) {
        Error error = new Error((ServerBaseException)new InternalServerException(exception), "USER_MESSAGE");
        return Response.status((int)500).entity((Object)BaseExceptionMapper.getJsonMapper().toJson((Object)error)).build();
    }
}

