/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.response;

import java.net.URI;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.stepniak.api.json.JsonMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseJson {
    private static final Logger logger = LoggerFactory.getLogger(ResponseJson.class);
    private final JsonMapper jsonMapper;
    protected final HttpServletRequest request;
    protected final UriInfo uriInfo;

    public ResponseJson(JsonMapper jsonMapper, UriInfo uriInfo, HttpServletRequest request) {
        this.jsonMapper = jsonMapper;
        this.uriInfo = uriInfo;
        this.request = request;
    }

    private Response response(Response.Status status, Object entity, URI locationPath, Date expires) {
        Response.ResponseBuilder builder = Response.status((Response.Status)status);
        if (entity != null) {
            builder.entity((Object)this.toJson(entity));
        }
        if (locationPath != null) {
            builder.location(locationPath);
        }
        if (expires != null) {
            builder.expires(expires);
        }
        return builder.build();
    }

    public Response ok(Object entity, URI locationPath, Date expires) {
        return this.response(Response.Status.OK, entity, locationPath, expires);
    }

    public Response ok(Object entity, URI locationPath) {
        return this.ok(entity, locationPath, null);
    }

    public Response ok(Object entity) {
        return this.ok(entity, null);
    }

    public Response created(Object entity, URI locationPath, Date expires) {
        return this.response(Response.Status.CREATED, entity, locationPath, expires);
    }

    public Response created(Object entity, URI locationPath) {
        return this.created(entity, locationPath, null);
    }

    private String toJson(Object entity) {
        return this.jsonMapper.toJson(entity);
    }
}

