/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.push.repository.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.stepniak.api.push.entity.DeviceEntity;
import net.stepniak.api.push.repository.DatabaseDeviceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryDeviceRepository
implements DatabaseDeviceRepository {
    private final Map<String, DeviceEntity> registeredDevices = new HashMap<String, DeviceEntity>();
    private final Logger logger = LoggerFactory.getLogger(InMemoryDeviceRepository.class);

    private void generateId(DeviceEntity entity) {
        if (entity.getId() == null) {
            entity.setId(String.valueOf(this.count()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <DeviceType extends DeviceEntity> DeviceType save(DeviceType pushDevice) {
        this.generateId(pushDevice);
        String id = pushDevice.getId();
        this.logger.info("register {} push device", (Object)id);
        Map<String, DeviceEntity> map = this.registeredDevices;
        synchronized (map) {
            this.registeredDevices.put(id, pushDevice);
        }
        return pushDevice;
    }

    public <DeviceType extends DeviceEntity> Iterable<DeviceType> save(Iterable<DeviceType> entities) {
        for (DeviceEntity pushDevice : entities) {
            this.save(pushDevice);
        }
        return entities;
    }

    public DeviceEntity findOne(String id) {
        this.logger.info("findOne: {}", (Object)id);
        return this.registeredDevices.get(id);
    }

    public boolean exists(String id) {
        this.logger.info("exists: {}", (Object)id);
        return this.registeredDevices.containsKey(id);
    }

    public Iterable<DeviceEntity> findAll() {
        this.logger.info("findAll");
        return new ArrayList<DeviceEntity>(this.registeredDevices.values());
    }

    public Iterable<DeviceEntity> findAll(Iterable<String> strings) {
        this.logger.info("findAll: {}", strings);
        return new ArrayList<DeviceEntity>(this.registeredDevices.values());
    }

    public long count() {
        this.logger.info("count");
        return this.registeredDevices.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String id) {
        this.logger.info("delete: {}", (Object)id);
        Map<String, DeviceEntity> map = this.registeredDevices;
        synchronized (map) {
            this.registeredDevices.remove(id);
        }
    }

    public void delete(DeviceEntity pushDevice) {
        String regId = pushDevice.getId();
        this.delete(regId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Iterable<? extends DeviceEntity> deviceEntities) {
        Map<String, DeviceEntity> map = this.registeredDevices;
        synchronized (map) {
            for (DeviceEntity deviceEntity : deviceEntities) {
                this.delete(deviceEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        this.logger.info("deleteAll");
        Map<String, DeviceEntity> map = this.registeredDevices;
        synchronized (map) {
            this.registeredDevices.clear();
        }
    }
}

