/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.push.entity;

import java.net.InetAddress;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import net.stepniak.api.entities.Pojo;
import net.stepniak.common.pojos.push.v1.PushDevice;
import net.stepniak.common.pojos.push.v1.device.PushDeviceLocale;
import net.stepniak.common.pojos.push.v1.device.PushDeviceType;
import org.apache.commons.lang.StringUtils;

@Entity
@Table(name="push_device")
public class DeviceEntity
implements Pojo {
    @Id
    @Column(columnDefinition="char(255)", unique=true, nullable=false, length=255)
    private String id;
    @Column(unique=false, nullable=false)
    private int type;
    @Column(unique=false, nullable=false)
    private int messagesMask;
    @Column(unique=true, nullable=false)
    private String alias;
    @Column(columnDefinition="char(5)", unique=false, nullable=false, length=5)
    private String locale;
    @Column(columnDefinition="char(255)", unique=false, nullable=false, length=255)
    private String timezone;
    @Column(nullable=false, length=40)
    private String remoteAddress;
    @Column(nullable=true, length=255)
    private String forwardedFor;

    public String getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public int getMessagesMask() {
        return this.messagesMask;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getForwardedFor() {
        return this.forwardedFor;
    }

    public DeviceEntity withId(String id) {
        this.id = id;
        return this;
    }

    public DeviceEntity withType(PushDeviceType type) {
        this.type = type.getType();
        return this;
    }

    public DeviceEntity withMessagesMask(int messagesMask) {
        this.messagesMask = messagesMask;
        return this;
    }

    public DeviceEntity withAlias(String alias) {
        if (!StringUtils.isEmpty((String)alias)) {
            this.alias = alias;
        }
        return this;
    }

    public DeviceEntity withLocale(PushDeviceLocale locale) {
        this.locale = locale.getType();
        return this;
    }

    public DeviceEntity withTimezone(String timezone) {
        if (!StringUtils.isEmpty((String)timezone)) {
            this.timezone = timezone;
        }
        return this;
    }

    public DeviceEntity withRemoteAddress(InetAddress remoteAddress) {
        this.remoteAddress = remoteAddress.getHostAddress();
        return this;
    }

    public DeviceEntity withForwardedFor(InetAddress forwardedFor) {
        this.forwardedFor = forwardedFor.getHostAddress();
        return this;
    }

    public PushDevice getPojos() {
        return new PushDevice(this.getId(), this.getType(), this.getMessagesMask(), this.getAlias(), this.getLocale(), this.getTimezone(), this.getRemoteAddress(), this.getForwardedFor());
    }

    public void setId(String id) {
        this.id = id;
    }
}

