/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.push.controller;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.stepniak.api.controller.ApiController;
import net.stepniak.api.push.PushStorage;
import net.stepniak.api.push.entity.DeviceEntity;
import net.stepniak.api.response.ResponseJson;
import net.stepniak.common.pojos.push.v1.device.PushDeviceLocale;
import net.stepniak.common.pojos.push.v1.device.PushDeviceType;
import net.stepniak.common.request.push.v1.RequestPushRegister;
import net.stepniak.common.request.push.v1.RequestPushUnRegister;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="push")
@Produces(value={"application/json; charset=utf-8"})
@Service
public class PushDevicesController
extends ApiController {
    private static final Logger logger = LoggerFactory.getLogger(PushDevicesController.class);
    @Autowired
    private PushStorage deviceRepository;

    @POST
    @Path(value="/register")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response registerByForm(@FormParam(value="deviceId") String deviceId, @FormParam(value="deviceType") int deviceType, @FormParam(value="messagesMask") int messagesMask, @FormParam(value="alias") String alias, @FormParam(value="locale") String locale, @FormParam(value="timezone") String timezone) {
        RequestPushRegister req = new RequestPushRegister(deviceId, deviceType, messagesMask, alias, locale, timezone);
        logger.info("registerByForm(\"{}\", {}, {}, \"{}\", \"{}\", \"{}\")", new Object[]{deviceId, deviceType, messagesMask, alias, locale, timezone});
        return this.register(req);
    }

    @POST
    @Path(value="/register")
    public Response registerByQueryString(@QueryParam(value="deviceId") String deviceId, @QueryParam(value="deviceType") int deviceType, @QueryParam(value="messagesMask") int messagesMask, @QueryParam(value="alias") String alias, @QueryParam(value="locale") String locale, @QueryParam(value="timezone") String timezone) {
        RequestPushRegister req = new RequestPushRegister(deviceId, deviceType, messagesMask, alias, locale, timezone);
        logger.info("registerByQueryString(\"{}\", {}, {}, \"{}\", \"{}\", \"{}\")", new Object[]{deviceId, deviceType, messagesMask, alias, locale, timezone});
        return this.register(req);
    }

    @POST
    @Path(value="/register")
    @Consumes(value={"application/json"})
    public Response registerByJson(JSONObject jsonObject) {
        RequestPushRegister req = (RequestPushRegister)this.fromJson(jsonObject, RequestPushRegister.class);
        logger.info("registerByJson(\"{}\", {}, {})", new Object[]{req.getDeviceId(), req.getDeviceType(), req.getMessagesMask()});
        return this.register(req);
    }

    @POST
    @Path(value="/unregister")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response unregisterByForm(@FormParam(value="deviceId") String deviceId, @FormParam(value="deviceType") int deviceType) {
        RequestPushUnRegister req = new RequestPushUnRegister(deviceId, deviceType);
        logger.info("unregisterByForm(\"{}\", {})", (Object)req.getDeviceId(), (Object)req.getDeviceType());
        return this.unregister(req);
    }

    @POST
    @Path(value="/unregister")
    public Response unregisterByQueryString(@QueryParam(value="deviceId") String deviceId, @QueryParam(value="deviceType") int deviceType) {
        RequestPushUnRegister req = new RequestPushUnRegister(deviceId, deviceType);
        logger.info("unregisterByQueryString(\"{}\", {})", (Object)req.getDeviceId(), (Object)req.getDeviceType());
        return this.unregister(req);
    }

    @POST
    @Path(value="/unregister")
    @Consumes(value={"application/json"})
    public Response unregisterByJson(JSONObject jsonObject) {
        RequestPushUnRegister req = (RequestPushUnRegister)this.fromJson(jsonObject, RequestPushUnRegister.class);
        logger.info("unregisterByJson(\"{}\", {})", (Object)req.getDeviceId(), (Object)req.getDeviceType());
        return this.unregister(req);
    }

    @GET
    @Path(value="/list")
    public Response list() {
        logger.info("list devices");
        ResponseJson responseJson = new ResponseJson(this.jsonMapper, this.uriInfo, this.request);
        return responseJson.ok(this.deviceRepository.getDevices());
    }

    private Response register(RequestPushRegister req) {
        DeviceEntity pushDevice = this.getDeviceEntity(req);
        pushDevice = this.deviceRepository.register(pushDevice);
        ResponseJson responseJson = new ResponseJson(this.jsonMapper, this.uriInfo, this.request);
        return responseJson.ok((Object)pushDevice.getPojos());
    }

    private Response unregister(RequestPushUnRegister req) {
        DeviceEntity pushDevice = this.deviceRepository.find(req.getDeviceId());
        this.deviceRepository.unregister(pushDevice);
        ResponseJson responseJson = new ResponseJson(this.jsonMapper, this.uriInfo, this.request);
        return responseJson.ok((Object)pushDevice.getPojos());
    }

    private DeviceEntity getDeviceEntity(RequestPushRegister req) {
        int deviceType = req.getDeviceType();
        PushDeviceType pushDeviceType = PushDeviceType.get((int)deviceType);
        if (pushDeviceType == null) {
            logger.warn("can't recognize device type id: {}", (Object)deviceType);
        }
        DeviceEntity pushDevice = new DeviceEntity();
        try {
            InetAddress remoteAddress = InetAddress.getByName(this.request.getRemoteAddr());
            if (remoteAddress != null) {
                pushDevice.withRemoteAddress(remoteAddress);
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        try {
            InetAddress forwardedFor = InetAddress.getByName(this.request.getHeader("X-FORWARDED-FOR"));
            if (forwardedFor != null) {
                pushDevice.withForwardedFor(forwardedFor);
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        PushDeviceLocale locale = PushDeviceLocale.get((String)req.getLocale());
        if (locale == null) {
            logger.warn("can't map locale to enum: {}", (Object)req.getLocale());
        }
        pushDevice.withId(req.getDeviceId()).withType(pushDeviceType).withMessagesMask(req.getMessagesMask()).withAlias(req.getAlias()).withLocale(locale).withTimezone(req.getTimezone());
        return pushDevice;
    }
}

