/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.push;

import java.io.Serializable;
import net.stepniak.api.push.entity.DeviceEntity;
import net.stepniak.api.push.repository.DatabaseDeviceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushStorage {
    private static final Logger logger = LoggerFactory.getLogger(PushStorage.class);
    @Autowired
    private DatabaseDeviceRepository pushDatastore;

    public DeviceEntity register(DeviceEntity pushDevice) {
        if (pushDevice != null) {
            logger.debug("register id: \"{}\", type: {}, mask: {}", new Object[]{pushDevice.getId(), pushDevice.getType(), pushDevice.getMessagesMask()});
            return (DeviceEntity)this.pushDatastore.save(pushDevice);
        }
        logger.debug("not found device");
        return null;
    }

    public void unregister(DeviceEntity pushDevice) {
        if (pushDevice != null) {
            logger.debug("unregister id: \"{}\"", (Object)pushDevice.getId());
            this.pushDatastore.delete((Serializable)((Object)pushDevice.getId()));
        } else {
            logger.debug("not found device");
        }
    }

    public DeviceEntity find(String id) {
        logger.debug("find device id: \"{}\"", (Object)id);
        return (DeviceEntity)this.pushDatastore.findOne((Serializable)((Object)id));
    }

    public void updateRegistration(String oldId, String newId) {
        logger.debug("updateRegistration old: \"{}\", newId: \"{}\"", (Object)oldId, (Object)newId);
        DeviceEntity pushDevice = this.find(oldId);
        if (pushDevice != null) {
            pushDevice.withId(newId);
            this.register(pushDevice);
            this.pushDatastore.delete((Serializable)((Object)oldId));
        } else {
            logger.debug("not found device");
        }
    }

    public Iterable<DeviceEntity> getDevices() {
        logger.debug("getDevices");
        return this.pushDatastore.findAll();
    }
}

