/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth.repository.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.stepniak.api.auth.entity.UserEntity;
import net.stepniak.api.auth.repository.UserRepository;
import org.apache.commons.lang.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.query.Param;

public final class InMemoryUserRepository
implements UserRepository {
    private final Map<Long, UserEntity> memoryMap = new HashMap<Long, UserEntity>();
    private final Logger logger = LoggerFactory.getLogger(InMemoryUserRepository.class);

    private void generateId(UserEntity entity) {
        if (entity.getId() == null) {
            entity.setId(this.count());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Entity extends UserEntity> Entity save(Entity entity) {
        this.generateId(entity);
        Long id = entity.getId();
        this.logger.info("save with id: {}", (Object)id);
        Map<Long, UserEntity> map = this.memoryMap;
        synchronized (map) {
            this.memoryMap.put(id, entity);
        }
        return entity;
    }

    public <Entity extends UserEntity> Iterable<Entity> save(Iterable<Entity> entities) {
        for (UserEntity entity : entities) {
            this.save(entity);
        }
        return entities;
    }

    public UserEntity findOne(Long id) {
        this.logger.info("findOne: {}", (Object)id);
        return this.memoryMap.get(id);
    }

    public boolean exists(Long id) {
        this.logger.info("exists: {}", (Object)id);
        return this.memoryMap.containsKey(id);
    }

    public Iterable<UserEntity> findAll() {
        this.logger.info("findAll");
        return new ArrayList<UserEntity>(this.memoryMap.values());
    }

    public Iterable<UserEntity> findAll(Iterable<Long> strings) {
        this.logger.info("findAll: {}", strings);
        return new ArrayList<UserEntity>(this.memoryMap.values());
    }

    public long count() {
        this.logger.info("count");
        return this.memoryMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Long id) {
        this.logger.info("delete: {}", (Object)id);
        Map<Long, UserEntity> map = this.memoryMap;
        synchronized (map) {
            this.memoryMap.remove(id);
        }
    }

    public void delete(UserEntity entity) {
        Long id = entity.getId();
        this.delete(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Iterable<? extends UserEntity> entities) {
        Map<Long, UserEntity> map = this.memoryMap;
        synchronized (map) {
            for (UserEntity userEntity : entities) {
                this.delete(userEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        this.logger.info("deleteAll");
        Map<Long, UserEntity> map = this.memoryMap;
        synchronized (map) {
            this.memoryMap.clear();
        }
    }

    @Override
    public UserEntity findByEmailAndUserNameAndAccountType(@Param(value="email") String email, @Param(value="userName") String userName, @Param(value="accountType") char accountType) {
        throw new NotImplementedException();
    }
}

