/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth.repository.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.stepniak.api.auth.entity.SessionEntity;
import net.stepniak.api.auth.repository.SessionRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemorySessionRepository
implements SessionRepository {
    private final Map<String, SessionEntity> memoryMap = new HashMap<String, SessionEntity>();
    private final Logger logger = LoggerFactory.getLogger(InMemorySessionRepository.class);

    private void generateId(SessionEntity entity) {
        if (entity.getId() == null) {
            entity.setId(String.valueOf(this.count()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Entity extends SessionEntity> Entity save(Entity entity) {
        this.generateId(entity);
        String id = entity.getId();
        this.logger.info("save with id: {}", (Object)id);
        Map<String, SessionEntity> map = this.memoryMap;
        synchronized (map) {
            this.memoryMap.put(id, entity);
        }
        return entity;
    }

    public <Entity extends SessionEntity> Iterable<Entity> save(Iterable<Entity> entities) {
        for (SessionEntity entity : entities) {
            this.save(entity);
        }
        return entities;
    }

    public SessionEntity findOne(String id) {
        this.logger.info("findOne: {}", (Object)id);
        return this.memoryMap.get(id);
    }

    public boolean exists(String id) {
        this.logger.info("exists: {}", (Object)id);
        return this.memoryMap.containsKey(id);
    }

    public Iterable<SessionEntity> findAll() {
        this.logger.info("findAll");
        return new ArrayList<SessionEntity>(this.memoryMap.values());
    }

    public Iterable<SessionEntity> findAll(Iterable<String> strings) {
        this.logger.info("findAll: {}", strings);
        return new ArrayList<SessionEntity>(this.memoryMap.values());
    }

    public long count() {
        this.logger.info("count");
        return this.memoryMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String id) {
        this.logger.info("delete: {}", (Object)id);
        Map<String, SessionEntity> map = this.memoryMap;
        synchronized (map) {
            this.memoryMap.remove(id);
        }
    }

    public void delete(SessionEntity entity) {
        String id = entity.getId();
        this.delete(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Iterable<? extends SessionEntity> entities) {
        Map<String, SessionEntity> map = this.memoryMap;
        synchronized (map) {
            for (SessionEntity sessionEntity : entities) {
                this.delete(sessionEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        this.logger.info("deleteAll");
        Map<String, SessionEntity> map = this.memoryMap;
        synchronized (map) {
            this.memoryMap.clear();
        }
    }
}

