/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth.repository.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.stepniak.api.auth.entity.KeyEntity;
import net.stepniak.api.auth.repository.KeyRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryKeyRepository
implements KeyRepository {
    private final Map<String, KeyEntity> memoryMap = new HashMap<String, KeyEntity>();
    private final Logger logger = LoggerFactory.getLogger(InMemoryKeyRepository.class);

    private void generateId(KeyEntity entity) {
        if (entity.getId() == null) {
            entity.setId(String.valueOf(this.count()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Entity extends KeyEntity> Entity save(Entity entity) {
        this.generateId(entity);
        String id = entity.getId();
        this.logger.info("save with id: {}", (Object)id);
        Map<String, KeyEntity> map = this.memoryMap;
        synchronized (map) {
            this.memoryMap.put(id, entity);
        }
        return entity;
    }

    public <Entity extends KeyEntity> Iterable<Entity> save(Iterable<Entity> entities) {
        for (KeyEntity entity : entities) {
            this.save(entity);
        }
        return entities;
    }

    public KeyEntity findOne(String id) {
        this.logger.info("findOne: {}", (Object)id);
        return this.memoryMap.get(id);
    }

    public boolean exists(String id) {
        this.logger.info("exists: {}", (Object)id);
        return this.memoryMap.containsKey(id);
    }

    public Iterable<KeyEntity> findAll() {
        this.logger.info("findAll");
        return new ArrayList<KeyEntity>(this.memoryMap.values());
    }

    public Iterable<KeyEntity> findAll(Iterable<String> strings) {
        this.logger.info("findAll: {}", strings);
        return new ArrayList<KeyEntity>(this.memoryMap.values());
    }

    public long count() {
        this.logger.info("count");
        return this.memoryMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String id) {
        this.logger.info("delete: {}", (Object)id);
        Map<String, KeyEntity> map = this.memoryMap;
        synchronized (map) {
            this.memoryMap.remove(id);
        }
    }

    public void delete(KeyEntity entity) {
        String id = entity.getId();
        this.delete(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Iterable<? extends KeyEntity> entities) {
        Map<String, KeyEntity> map = this.memoryMap;
        synchronized (map) {
            for (KeyEntity keyEntity : entities) {
                this.delete(keyEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        this.logger.info("deleteAll");
        Map<String, KeyEntity> map = this.memoryMap;
        synchronized (map) {
            this.memoryMap.clear();
        }
    }
}

