/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import net.stepniak.api.auth.entity.BaseAuthEntity;
import net.stepniak.api.entities.Pojo;
import net.stepniak.common.pojos.auth.v1.User;
import net.stepniak.common.user.AccountType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.LastModifiedDate;

@Entity
@Table(name="auth_users")
public class UserEntity
extends BaseAuthEntity<Long>
implements Pojo {
    private static final Logger logger = LoggerFactory.getLogger(UserEntity.class);
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE)
    @Column(unique=true, nullable=false, insertable=true)
    private Long id;
    @Column(unique=true, nullable=false, length=25)
    public String userName;
    @Column(unique=true, nullable=false, length=100)
    public String email;
    @Column(nullable=false, length=100)
    public char accountType;
    @Temporal(value=TemporalType.TIMESTAMP)
    @LastModifiedDate
    private Date updateDate;

    public UserEntity() {
    }

    public UserEntity(String userName, String email, AccountType accountType) {
        this.userName = userName;
        this.email = email;
        this.accountType = accountType.getCode();
    }

    public String getName() {
        return this.userName;
    }

    public String getEmail() {
        return this.email;
    }

    public char getAccountType() {
        return this.accountType;
    }

    public User getPojos() {
        return new User(String.valueOf(this.getId()), this.getName());
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date date) {
        this.updateDate = new Date();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }
}

