/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import net.stepniak.api.auth.entity.BaseAuthEntity;
import net.stepniak.api.auth.entity.KeyEntity;
import net.stepniak.api.auth.entity.UserEntity;
import net.stepniak.api.entities.Pojo;
import net.stepniak.common.pojos.auth.v1.Session;
import net.stepniak.common.pojos.auth.v1.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="auth_sessions")
public class SessionEntity
extends BaseAuthEntity<String>
implements Pojo {
    private static final Logger logger = LoggerFactory.getLogger(SessionEntity.class);
    @Id
    @Column(columnDefinition="char(64)", unique=true, nullable=false, insertable=true, length=64)
    private String id;
    @ManyToOne
    private UserEntity userEntity;
    @ManyToOne
    public KeyEntity keyLogic;
    @Column(nullable=false, length=40)
    public String remoteAddress;
    @Column(nullable=true, length=255)
    public String forwardedFor;
    private Date expire;

    public SessionEntity(String sessId, KeyEntity keyEntity) {
        this.setId(sessId);
        this.keyLogic = keyEntity;
    }

    public SessionEntity() {
    }

    public Date getExpiration() {
        return this.expire;
    }

    public Session getPojos() {
        User user = null;
        if (this.getUserEntity() != null) {
            user = this.getUserEntity().getPojos();
        }
        return new Session(this.getId(), user, this.getCreationDate(), this.getExpiration());
    }

    @Override
    public void setCreationDate(Date creationDate) {
        super.setCreationDate(creationDate);
        this.expire = this.calculateExpiration();
    }

    private Date calculateExpiration() {
        long created = this.getCreationDate() == null ? System.currentTimeMillis() : this.getCreationDate().getTime();
        return new Date(created + 3600000L);
    }

    public void setUserEntity(UserEntity userEntity) {
        this.userEntity = userEntity;
    }

    public UserEntity getUserEntity() {
        return this.userEntity;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String clientIp) {
        this.remoteAddress = clientIp;
    }

    public String getForwardedFor() {
        return this.forwardedFor;
    }

    public void setForwardedFor(String clientForwarderFor) {
        this.forwardedFor = clientForwarderFor;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}

