/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import net.stepniak.api.auth.entity.BaseAuthEntity;
import net.stepniak.api.entities.Pojo;
import net.stepniak.common.pojos.auth.v1.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="auth_keys")
public class KeyEntity
extends BaseAuthEntity<String>
implements Pojo {
    private static final Logger logger = LoggerFactory.getLogger(KeyEntity.class);
    @Id
    @Column(columnDefinition="char(24)", unique=true, nullable=false, insertable=true, length=24)
    private String id;
    private Date expire;

    public KeyEntity() {
    }

    public KeyEntity(String keyId) {
        this.setId(keyId);
    }

    public Date getExpiration() {
        return this.expire;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        super.setCreationDate(creationDate);
        this.expire = this.calculateExpiration();
    }

    public Key getPojos() {
        return new Key(this.getId(), this.getCreationDate(), this.getExpiration());
    }

    private Date calculateExpiration() {
        long created = this.getCreationDate() == null ? System.currentTimeMillis() : this.getCreationDate().getTime();
        return new Date(created + 31536000000L);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}

