/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.CreatedDate;

@MappedSuperclass
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class BaseAuthEntity<IdType> {
    private static final Logger logger = LoggerFactory.getLogger(BaseAuthEntity.class);
    @Temporal(value=TemporalType.TIMESTAMP)
    @CreatedDate
    @Column(updatable=false)
    private Date creationDate = new Date();

    public abstract IdType getId();

    public abstract void setId(IdType var1);

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? super.hashCode() : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseAuthEntity other = (BaseAuthEntity)obj;
        if (this.getId() == null) {
            if (other.getId() != null) {
                return false;
            }
            return super.equals(obj);
        }
        return this.getId().equals(other.getId());
    }
}

