/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth.controller;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.stepniak.api.auth.UserStore;
import net.stepniak.api.auth.controller.BaseAuthController;
import net.stepniak.api.auth.entity.UserEntity;
import net.stepniak.api.auth.exception.auth.AuthException;
import net.stepniak.api.auth.validator.user.UserRegisterValidator;
import net.stepniak.api.response.ResponseJson;
import net.stepniak.api.utils.Analytics;
import net.stepniak.common.error.http.ForbiddenException;
import net.stepniak.common.error.http.NotFoundException;
import net.stepniak.common.error.http.badRequest.BadRequestValidateException;
import net.stepniak.common.error.http.forbidden.ForbiddenType;
import net.stepniak.common.request.auth.v1.RequestRegister;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionSystemException;

@Path(value="users")
@Produces(value={"application/json; charset=utf-8"})
@Service
public class UserController
extends BaseAuthController {
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    private static final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    private final UserStore userStore;

    @Autowired
    public UserController(UserStore userStore) {
        this.userStore = userStore;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createExternalByForm(@FormParam(value="key") String key, @FormParam(value="email") String email, @FormParam(value="userName") String userName) throws AuthException {
        RequestRegister request = new RequestRegister(email, userName);
        logger.info("UserController createExternalByForm(\"{}\", \"{}\", \"{}\")", new Object[]{key, request.getEmail(), request.getUserName()});
        return this.createUser(key, request);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createExternalByJson(JSONObject jsonObject) throws AuthException {
        RequestRegister req = (RequestRegister)this.fromJson(jsonObject, RequestRegister.class);
        logger.info("UserController createExternalByJson(\"{}\", \"{}\")", (Object)req.getEmail(), (Object)req.getUserName());
        return this.createUser(null, req);
    }

    @POST
    public Response createByQueryString(@QueryParam(value="key") String key, @QueryParam(value="email") String email, @QueryParam(value="userName") String userName) throws AuthException {
        RequestRegister request = new RequestRegister(email, userName);
        logger.info("UserController createByQueryString(\"{}\", \"{}\", \"{}\")", new Object[]{key, request.getEmail(), request.getUserName()});
        return this.createUser(key, request);
    }

    private Response createUser(String key, RequestRegister reqs) throws AuthException {
        key = this.validateApiKey(key);
        Analytics.track((String)String.format("/users?key=%s&userName=%s&email=%s", key, reqs.getUserName(), reqs.getEmail()), (String)"users:create");
        UserRegisterValidator req = new UserRegisterValidator(reqs);
        Set constraintViolations = validator.validate((Object)req, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new BadRequestValidateException(((ConstraintViolation)constraintViolations.iterator().next()).getMessage());
        }
        try {
            UserEntity userEntity = this.userStore.create(req.getUserName(), req.getEmail());
            logger.debug("created user id: \"{}\",", (Object)userEntity.getId());
            ResponseJson responseJson = new ResponseJson(this.jsonMapper, this.uriInfo, this.request);
            return responseJson.created((Object)userEntity.getPojos(), UriBuilder.fromPath((String)("/" + userEntity.getId())).build(new Object[0]));
        }
        catch (DataIntegrityViolationException exc) {
            logger.warn("unable to create user", (Throwable)exc);
            throw new ForbiddenException(ForbiddenType.USER_ALREADY_EXISTS, (Throwable)exc);
        }
        catch (TransactionSystemException exc) {
            logger.warn("unable to create user", (Throwable)exc);
            throw new ForbiddenException(ForbiddenType.USER_ALREADY_EXISTS, (Throwable)exc);
        }
    }

    @GET
    @Path(value="/{id}")
    public Response retrieve(@PathParam(value="id") Long id, @QueryParam(value="sessionId") String sessionId) throws AuthException {
        sessionId = this.validateSessionId(sessionId);
        logger.info("AuthController retrieve(\"{}\")", (Object)id);
        Analytics.track((String)String.format("/users/%s", id), (String)"users:retrieve");
        UserEntity entity = this.userStore.find(id);
        if (entity == null) {
            throw new NotFoundException();
        }
        ResponseJson responseJson = new ResponseJson(this.jsonMapper, this.uriInfo, this.request);
        return responseJson.ok((Object)entity.getPojos());
    }
}

