/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth.controller;

import java.security.NoSuchAlgorithmException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.stepniak.api.auth.KeyStore;
import net.stepniak.api.auth.controller.BaseAuthController;
import net.stepniak.api.auth.entity.KeyEntity;
import net.stepniak.api.response.ResponseJson;
import net.stepniak.api.utils.Analytics;
import net.stepniak.common.error.http.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="keys")
@Produces(value={"application/json; charset=utf-8"})
@Service
public class KeyController
extends BaseAuthController {
    private static final Logger logger = LoggerFactory.getLogger(KeyController.class);
    private final KeyStore keyStore;

    @Autowired
    public KeyController(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @POST
    public Response create() throws NoSuchAlgorithmException {
        logger.debug("create()");
        Analytics.track((String)"/keys", (String)"keys:create");
        KeyEntity keyEntity = this.keyStore.create();
        ResponseJson responseJson = new ResponseJson(this.jsonMapper, this.uriInfo, this.request);
        return responseJson.created((Object)keyEntity.getPojos(), UriBuilder.fromPath((String)("/" + keyEntity.getId())).build(new Object[0]), keyEntity.getExpiration());
    }

    @GET
    @Path(value="/{id}")
    public Response retrieve(@PathParam(value="id") String id) {
        logger.info("retrieve(\"{}\")", (Object)id);
        Analytics.track((String)String.format("/keys/%s", id), (String)"keys:retrieve");
        KeyEntity entity = this.keyStore.find(id);
        if (entity == null) {
            throw new NotFoundException();
        }
        ResponseJson responseJson = new ResponseJson(this.jsonMapper, this.uriInfo, this.request);
        return responseJson.ok((Object)entity.getPojos());
    }
}

