/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth.controller;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.stepniak.api.auth.Auth;
import net.stepniak.api.auth.entity.UserEntity;
import net.stepniak.api.auth.exception.auth.AuthException;
import net.stepniak.api.controller.ApiController;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseAuthController
extends ApiController {
    private static final Logger logger = LoggerFactory.getLogger(BaseAuthController.class);
    private static final Pattern sessionIdHeaderPattern = Pattern.compile("^OAuth\\d? (.+)$");
    @Autowired
    protected Auth auth;

    public String getSessionId() {
        Matcher matcher;
        String authHeader = this.request.getHeader("Authorization");
        if (authHeader != null && (matcher = sessionIdHeaderPattern.matcher(authHeader)).matches()) {
            return matcher.group(1);
        }
        List sessionIdList = (List)this.uriInfo.getQueryParameters().get((Object)"sessionId");
        if (sessionIdList != null && !sessionIdList.isEmpty()) {
            return (String)sessionIdList.get(0);
        }
        return null;
    }

    protected String validateSessionId(String sessionId) throws AuthException {
        if (StringUtils.isEmpty((String)sessionId)) {
            sessionId = this.getSessionId();
        }
        logger.debug("validateSessionId: {}", (Object)sessionId);
        return this.auth.validateSessionId(sessionId);
    }

    protected UserEntity getAuthorizedUser(String sessionId) throws AuthException {
        sessionId = this.validateSessionId(sessionId);
        logger.debug("getAuthorizedUser: {}", (Object)sessionId);
        return this.auth.getAuthorizedUser(sessionId);
    }

    protected String validateApiKey(String key) throws AuthException {
        if (StringUtils.isEmpty((String)key)) {
            key = this.getApiKey();
        }
        logger.debug("validateApiKey: {}", (Object)key);
        return this.auth.validateApiKey(key);
    }

    private String getApiKey() {
        List keyList = (List)this.uriInfo.getQueryParameters().get((Object)"key");
        if (keyList != null && !keyList.isEmpty()) {
            return (String)keyList.get(0);
        }
        return null;
    }
}

