/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth.controller;

import java.security.NoSuchAlgorithmException;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.stepniak.api.auth.SessionStore;
import net.stepniak.api.auth.UserStore;
import net.stepniak.api.auth.controller.BaseAuthController;
import net.stepniak.api.auth.entity.KeyEntity;
import net.stepniak.api.auth.entity.SessionEntity;
import net.stepniak.api.auth.entity.UserEntity;
import net.stepniak.api.auth.exception.auth.AuthException;
import net.stepniak.api.auth.exception.auth.AuthInvalidApiKeyException;
import net.stepniak.api.auth.validator.user.UserAuthValidator;
import net.stepniak.api.response.ResponseJson;
import net.stepniak.api.utils.Analytics;
import net.stepniak.common.error.http.ForbiddenException;
import net.stepniak.common.error.http.InternalServerException;
import net.stepniak.common.error.http.NotFoundException;
import net.stepniak.common.error.http.badRequest.BadRequestValidateException;
import net.stepniak.common.request.auth.v1.RequestAuth;
import net.stepniak.common.request.auth.v1.RequestAuthExternal;
import net.stepniak.common.user.AccountType;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionSystemException;

@Path(value="auth")
@Produces(value={"application/json; charset=utf-8"})
@Service
public class AuthController
extends BaseAuthController {
    private static final Logger logger = LoggerFactory.getLogger(AuthController.class);
    private static final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    private final SessionStore sessionStore;
    private final UserStore userStore;

    @Autowired
    public AuthController(SessionStore sessionStore, UserStore userStore) {
        this.sessionStore = sessionStore;
        this.userStore = userStore;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createByForm(@FormParam(value="key") String key, @FormParam(value="email") String email, @FormParam(value="userName") String userName) throws AuthException {
        RequestAuth request = new RequestAuth(email, userName);
        logger.info("createByForm(\"{}\", \"{}\", \"{}\")", new Object[]{key, request.getEmail(), request.getUserName()});
        return this.auth(key, request);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createByJson(JSONObject jsonObject) throws AuthException {
        RequestAuth request = (RequestAuth)this.fromJson(jsonObject, RequestAuth.class);
        logger.info("createByJson(\"{}\", \"{}\")", (Object)request.getEmail(), (Object)request.getUserName());
        return this.auth(null, request);
    }

    @POST
    public Response createByQueryString(@QueryParam(value="key") String key, @QueryParam(value="email") String email, @QueryParam(value="userName") String userName) throws AuthException {
        RequestAuth request = new RequestAuth(email, userName);
        logger.info("createByQueryString(\"{}\", \"{}\", \"{}\")", new Object[]{key, request.getEmail(), request.getUserName()});
        return this.auth(key, request);
    }

    private Response auth(String key, RequestAuth reqs) throws AuthException {
        key = this.validateApiKey(key);
        Analytics.track((String)String.format("/auth?key=%s&email=%s&userName=%s", key, reqs.getEmail(), reqs.getUserName()), (String)"auth");
        UserAuthValidator req = new UserAuthValidator(reqs);
        try {
            KeyEntity keyEntity = new KeyEntity(key);
            UserEntity userLogic = this.findUser(req);
            SessionEntity sessionEntity = this.sessionStore.create(keyEntity, userLogic, this.request.getRemoteAddr(), this.request.getHeader("X-FORWARDED-FOR"));
            ResponseJson responseJson = new ResponseJson(this.jsonMapper, this.uriInfo, this.request);
            return responseJson.created((Object)sessionEntity.getPojos(), UriBuilder.fromPath((String)("/" + sessionEntity.getId())).build(new Object[0]), sessionEntity.getExpiration());
        }
        catch (TransactionSystemException exc) {
            logger.error("can't generate session", (Throwable)exc);
            throw new AuthInvalidApiKeyException();
        }
        catch (DataIntegrityViolationException exc) {
            logger.error("can't generate session", (Throwable)exc);
            throw new AuthInvalidApiKeyException();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("can't generate session", (Throwable)e);
            throw new InternalServerException((Throwable)e);
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{type}")
    public Response createExternalByForm(@PathParam(value="type") String type, @FormParam(value="key") String key, @FormParam(value="userId") String userId, @FormParam(value="userName") String userName, @FormParam(value="firstName") String firstName, @FormParam(value="lastName") String lastName, @FormParam(value="locale") String locale) {
        RequestAuthExternal request = new RequestAuthExternal(userId, userName, firstName, lastName, locale);
        logger.info("createExternalByForm(\"{}\", \"{}\", \"{}\", \"{}\", \"{}\", \"{}\", \"{}\")", new Object[]{type, key, request.getUserId(), request.getUserName(), request.getFirstName(), request.getLastName(), request.getLocale()});
        return this.authExternal(type, key, request);
    }

    @POST
    @Path(value="{type}")
    @Consumes(value={"application/json"})
    public Response createExternalByJson(@PathParam(value="type") String type, JSONObject jsonObject) {
        RequestAuthExternal request = (RequestAuthExternal)this.fromJson(jsonObject, RequestAuthExternal.class);
        logger.info("createExternalByJson(\"{}\", \"{}\", \"{}\", \"{}\", \"{}\", \"{}\")", new Object[]{type, request.getUserId(), request.getUserName(), request.getFirstName(), request.getLastName(), request.getLocale()});
        return this.authExternal(type, null, request);
    }

    @POST
    @Path(value="{type}")
    public Response createExternalByQueryString(@PathParam(value="type") String type, @QueryParam(value="key") String key, @QueryParam(value="userId") String userId, @QueryParam(value="userName") String userName, @QueryParam(value="firstName") String firstName, @QueryParam(value="lastName") String lastName, @QueryParam(value="locale") String locale) {
        RequestAuthExternal request = new RequestAuthExternal(userId, userName, firstName, lastName, locale);
        logger.info("createByQueryString(\"{}\", \"{}\", \"{}\", \"{}\", \"{}\", \"{}\", \"{}\")", new Object[]{type, key, request.getUserId(), request.getUserName(), request.getFirstName(), request.getLastName(), request.getLocale()});
        return this.authExternal(type, key, request);
    }

    private Response authExternal(String type, String key, RequestAuthExternal req) {
        throw new ForbiddenException();
    }

    @GET
    @Path(value="/{id}")
    public Response retrieve(@PathParam(value="id") String id) {
        logger.info("retrieve(\"{}\")", (Object)id);
        Analytics.track((String)String.format("/auth/%s", id), (String)"auth:retrieve");
        SessionEntity entity = this.sessionStore.find(id);
        if (entity == null) {
            throw new NotFoundException();
        }
        ResponseJson responseJson = new ResponseJson(this.jsonMapper, this.uriInfo, this.request);
        return responseJson.ok((Object)entity.getPojos());
    }

    private UserEntity findUser(UserAuthValidator req) {
        boolean isUserName;
        String email = req.getEmail();
        String userName = req.getUserName();
        boolean isEmail = !StringUtils.isEmpty((String)email) && StringUtils.trim((String)email).length() > 0;
        boolean bl = isUserName = !StringUtils.isEmpty((String)userName) && StringUtils.trim((String)userName).length() > 0;
        if (isEmail || isUserName) {
            Set constraintViolations = validator.validate((Object)req, new Class[0]);
            if (!constraintViolations.isEmpty()) {
                throw new BadRequestValidateException(((ConstraintViolation)constraintViolations.iterator().next()).getMessage());
            }
            UserEntity userLogic = this.userStore.findUser(email, userName, AccountType.PICHEESE);
            if (userLogic == null) {
                logger.info("can't find user for email: \"{}\", userName: \"{}\" and userName: \"{}\"", new Object[]{email, userName, AccountType.PICHEESE});
                throw new NotFoundException();
            }
            return userLogic;
        }
        return null;
    }
}

